<?php

namespace App\Http\Controllers;

use EDGVI10\Helpers;
use App\Models\_navigation;
use App\Models\_siteinfo;
use Illuminate\Http\Request;
use illuminate\Support\Str;
use App\Repositories\NavigationRepository;
use Illuminate\Support\Facades\DB;

class NavigationController extends Controller
{
    public function __construct(_navigation $navigation)
    {
        $this->navigation = $navigation;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $navigationRepository = new NavigationRepository($this->navigation);

        if ($request->has('request_attributes')) :
            $navigationRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $navigationRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $navigationRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $navigationRepository->getResult('nav', $request->paginate);
        else :
            $return = $navigationRepository->getResult('nav', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->navigation->fields(), $request->all());
        if ($confirmation != 'true') :
            $return['message'] = 'Faltam campos obrigatórios';
            $return['errors'] = $confirmation;
        else :
            $response = $this->navigation->fill($request->all());
            if ($request->uuid == '') :
                $uuid = Str::uuid();
                $response->uuid = $uuid;
            endif;

            if ($response->save()) :
                $return['success'] = true;
                $return['nav'] = $response;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\_navigation  $_navigation
     * @return \Illuminate\Http\Response
     */
    public function show($uuid)
    {
        $return = [];
        $return['success'] = false;
        $response = $this->navigation->where('uuid', '=', $uuid)->get();
        //return response()->json($response);
        if (sizeof($response) == 0) :
            $return['errors'] = "Nav não encontrado";
        else :
            $return['success'] = true;
            $return['nav'] = $response[0];
        endif;

        return response()->json($return);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\_navigation  $_navigation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $uuid)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->navigation->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $response = $this->navigation->where('uuid', '=', $uuid)->get();

            if ($response[0] === null) :
                return response()->json(['error' => 'Cant find post']);
            endif;

            $response[0]->fill($request->all());
            if ($response[0]->save()) :
                $return["success"] = true;
                $return["post_data"] = $response[0];
            endif;
        endif;
        return response()->json($return);
        //
    }

    public function getNavItems($params)
    {
        $home_url = _siteinfo::where("key", "=", "home")->get()[0];

        $response = $this->navigation;
        if (isset($params["position"])) $response = $response->where('position', '=', $params["position"]);
        if (isset($params["parent_id"]))
            $response = $response->where('parent_id', '=', $params["parent_id"]);
        else
            $response = $response->whereNull('parent_id');

        $response = $response->where("active", "=", 1)->orderBy(DB::raw("ISNULL(`order`), `order`"), "ASC")->get();

        $navitems = [];
        foreach ($response as $item) {
            $item = (object) $item;
            $navitem = (object) [];
            $navitem->external = (bool) $item->external;
            $navitem->label = $item->label;

            if (!empty($item->url)) $navitem->url = (strpos($item->url, "/") === 0) ? $home_url->value . $item->url : $item->url;

            $navitem->description = $item->description;
            $navitem->class = $item->class;
            $navitem->icon = $item->icon;

            $submenu = $this->getNavItems(["parent_id" => $item->id]);
            if (count($submenu)) $navitem->submenu = $submenu;

            $navitems[] = $navitem;
        }

        return $navitems;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\_navigation  $_navigation
     * @return \Illuminate\Http\Response
     */
    public function destroy(_navigation $_navigation)
    {
        //
    }
}
