<?php

namespace App\Http\Controllers;

use EDGVI10\Helpers;
use App\Models\Post_category;
use Illuminate\Http\Request;
use illuminate\Support\Str;
use App\Repositories\PostCategoryRepository;
use Illuminate\Support\Facades\Storage;


class PostCategoryController extends Controller
{
    public function __construct(Post_category $postCategory)
    {
        $this->postCategory = $postCategory;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $postCategoryRepository = new PostCategoryRepository($this->postCategory);

        if ($request->has('request_attributes')) :
            $postCategoryRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $postCategoryRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $postCategoryRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $postCategoryRepository->getResult('posts_categories', $request->paginate);
        else :
            $return = $postCategoryRepository->getResult('posts_categories', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->postCategory->fields(), $request->all());

        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $response = $this->postCategory->fill($request->all());

            if ($request->uuid == '') :
                $uuid = Str::uuid();
                $response->uuid = $uuid;
            endif;
            if (!isset($request->slug) || empty($request->slug)) :
                $response->slug = Helpers::slugfy($response->title);
            endif;

            $verifySlug = $this->postCategory->where('slug', '=', $response->slug)->get();

            if (sizeof($verifySlug) != 0) :
                $return["message"] = "Slug ja cadastrado";
            else :
                if ($request->has('thumbnail')) :
                    $thumbnail = $request->file('thumbnail');
                    $thumbnail_urn = $thumbnail->store('postsCategories', 'public');
                    $response->thumbnail = $thumbnail_urn;
                endif;

                if ($response->save()) :
                    $return['success'] = true;
                    $return['post_category'] = $response;
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Post_category  $Post_category
     * @return \Illuminate\Http\Response
     */
    public function show($param)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->postCategory->where('uuid', '=', $param)->orWhere('slug', '=', $param)->get();
        if (sizeof($response) == 0) :
            $return['errors'] = "Post Category não encontrado";
        else :
            $return['success'] = true;
            $return['post_category'] = $response[0];
        endif;
        return response()->json($return);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Post_category  $Post_category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $uuid)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->postCategory->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $postCategory = $this->postCategory->where('uuid', '=', $uuid)->get();
            if (sizeof($postCategory) == 0) :
                $return['message'] = 'Post Category não encontrado';
            else :

                $response = $postCategory[0]->fill($request->except('thumbnail'));

                if (!isset($request->slug) || empty($request->slug)) :
                    $response->slug = Helpers::slugfy($request->title);
                endif;

                $verifySlug = Post_category::where('slug', '=', $response->slug)->where('uuid', '<>', $response->uuid)->get();

                if (sizeof($verifySlug) > 0) :
                    $return["message"] = "Slug ja cadastrado";
                else :

                    if ($request->file('thumbnail')) {
                        Storage::disk('public')->delete($response->thumbnail);
                        $thumbnail = $request->file('thumbnail');
                        $thumbnail_urn = $thumbnail->store('postsCategories', 'public');
                        $response->thumbnail = $thumbnail_urn;
                    }

                    if ($response->save()) {
                        $return['success'] = true;
                        $return['post_category'] = $response;
                    }
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Post_category  $Post_category
     * @return \Illuminate\Http\Response
     */
    public function destroy(Post_category $id)
    {
        //
    }
}
