<?php

namespace App\Http\Controllers;

use App\Models\Post;
use EDGVI10\Helpers;
use Illuminate\Http\Request;
use illuminate\Support\Str;
use App\Repositories\PostRepository;
use Illuminate\Support\Facades\Storage;


class PostController extends Controller
{

    public function __construct(Post $post)
    {
        $this->post = $post;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /*{

	"request_attributes": "id, title, slug, type",
	"request_filters": "title:=:Teste Title 2",
	"limit": 1,
	"page": 2,
	"paginate": 1
	
}*/
        //return response()->json($request->all());
        $postRepository = new PostRepository($this->post);

        if ($request->has('request_attributes')) :
            $postRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $postRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $postRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $postRepository->getResult('posts', $request->paginate);
        else :
            $return = $postRepository->getResult('posts', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->post->fields(), $request->all());

        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $response = $this->post->fill($request->all());
            if ($request->has('thumbnail')) :
                $thumbnail = $request->file('thumbnail');
                $thumbnail_urn = $thumbnail->store('posts', 'public');
                $response->thumbnail = $thumbnail_urn;
            endif;
            if ($request->uuid == '') :
                $uuid = Str::uuid();
                $response->uuid = $uuid;
            endif;

            if (!isset($request->slug) || empty($request->slug)) :
                $response->slug = Helpers::slugfy($response->title);
            endif;

            if (!isset($request->language) || empty($request->language)) :
                $response->language = "text";
            endif;

            if (!isset($request->type) || empty($request->type)) :
                $response->type = "page";
            endif;

            $verifySlug = $this->post->where('slug', '=', $response->slug)->get();

            if (sizeof($verifySlug) != 0) :
                $return["message"] = "Slug ja cadastrado";
            else :
                if ($response->save()) :
                    $return['success'] = true;
                    $return['post_category'] = $response;
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Post  $id
     * @return \Illuminate\Http\Response
     */
    public function show($param)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->post->where('uuid', '=', $param)->orWhere('slug', '=', $param)->get();
        if (sizeof($response) == 0) :
            $return['errors'] = "Post não encontrado";
        else :
            $return['success'] = true;
            $return['post'] = $response[0];
        endif;
        return response()->json($return);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Post  $Post
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $param)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->post->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $post = $this->post->where('uuid', '=', $param)->orWhere('slug', '=', $param)->get();
            if (sizeof($post) == 0) :
                $return['message'] = 'Post não encontrado';
            else :
                $response = $post[0]->fill($request->except('thumbnail'));

                if ((!isset($request->slug) || empty($request->slug)) && $response->slug == "") :
                    $response->slug = Helpers::slugfy($request->title);
                endif;

                $verifySlug = Post::where('slug', '=', $response->slug)->where('uuid', '<>', $response->uuid)->get();

                if (sizeof($verifySlug) > 0) :
                    $return["message"] = "Slug ja cadastrado";
                else :
                    if ($request->file('thumbnail')) {
                        Storage::disk('public')->delete($response->thumbnail);
                        $thumbnail = $request->file('thumbnail');
                        $thumbnail_urn = $thumbnail->store('posts', 'public');
                        $response->thumbnail = $thumbnail_urn;
                    }
                    if ($response->save()) {
                        $return['success'] = true;
                        $return['post'] = $response;
                    }
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Post  $Post
     * @return \Illuminate\Http\Response
     */
    public function destroy(Post $Post)
    {
        //
    }

    public function getBySlug($slug)
    {
    }
}
