<?php

namespace App\Http\Controllers;

use EDGVI10\Helpers;
use App\Models\Post_meta;
use Illuminate\Http\Request;
use App\Repositories\PostMetaRepository;

class PostMetaController extends Controller
{
    public function __construct(Post_meta $postMeta)
    {
        $this->postMeta = $postMeta;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $postMetaRepository = new PostMetaRepository($this->postMeta);

        if ($request->has('request_attributes')) :
            $postMetaRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $postMetaRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $postMetaRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $postMetaRepository->getResult('posts_metas', $request->paginate);
        else :
            $return = $postMetaRepository->getResult('posts_metas', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->postMeta->fields(), $request->all());

        if ($confirmation != 'true') :
            $return['message'] = 'Faltam Campos Obrigatórios';
            $return['errors'] = $confirmation;
        else :
            $response = $this->postMeta->create($request->all());
            if ($response) :
                $return['success'] = true;
                $return['post_meta'] = $response;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Post_meta  $Post_meta
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->postMeta->find($id);
        if ($response === null) :
            $return['errors'] = "Post meta não encontrado";
        else :
            $return['success'] = true;
            $return['post'] = $response;
        endif;
        return response()->json($return);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Post_meta  $Post_meta
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->postMeta->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $response = $this->postMeta->find($id);

            if ($response === null) :
                $return['errors'] = "Post meta não encontrado";
            else :
                $response->fill($request->all());
                if ($response->save()) {
                    $return['success'] = true;
                    $return['post_category'] = $response;
                }
            endif;
        endif;

        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Post_meta  $Post_meta
     * @return \Illuminate\Http\Response
     */
    public function destroy(Post_meta $Post_meta)
    {
        //
    }
}
