<?php

namespace App\Http\Controllers;

use EDGVI10\Helpers;
use App\Models\Post_type;
use Illuminate\Http\Request;
use App\Repositories\PostTypeRepository;

class PostTypeController extends Controller
{
    public function __construct(Post_type $postType)
    {
        $this->postType = $postType;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $postTypeController = new PostTypeRepository($this->postType);

        if ($request->has('request_attributes')) :
            $postTypeController->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $postTypeController->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $postTypeController->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $postTypeController->getResult('post_type', $request->paginate);
        else :
            $return = $postTypeController->getResult('post_type', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->postType->fields(), $request->all());

        if ($confirmation != 'true') :
            $return['message'] = 'Faltam Campos Obrigatórios';
            $return['errors'] = $confirmation;
        else :
            $response = $this->postType->create($request->all());
            if ($response) :
                $return['success'] = true;
                $return['post_type'] = $response;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Post_type  $Post_type
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->postType->find($id);
        if ($response === null) :
            $return['errors'] = "Post type não encontrado";
        else :
            $return['success'] = true;
            $return['post_type'] = $response;
        endif;
        return response()->json($return);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Post_type  $Post_type
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->postType->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $response = $this->postType->find($id);
            if ($response === null) :
                $return['errors'] = "Post type não encontrado";
            else :
                $response->fill($request->all());
                if ($response->save()) {
                    $return['success'] = true;
                    $return['post_type'] = $response;
                }
            endif;
        endif;

        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Post_type  $Post_type
     * @return \Illuminate\Http\Response
     */
    public function destroy(Post_type $Post_type)
    {
        //
    }
}
