<?php

namespace App\Http\Controllers;

use App\Models\Product_brand;
use EDGVI10\Helpers;
use Illuminate\Http\Request;
use illuminate\Support\Str;
use App\Repositories\ProductBrandRepository;
use Illuminate\Support\Facades\Storage;

class ProductBrandController extends Controller

{
    public function __construct(Product_brand $productBrand)
    {
        $this->productBrand = $productBrand;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $productBrandRepository = new ProductBrandRepository($this->productBrand);

        if ($request->has('request_attributes')) :
            $productBrandRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $productBrandRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $productBrandRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $productBrandRepository->getResult('products_brands', $request->paginate);
        else :
            $return = $productBrandRepository->getResult('products_brands', false);
        endif;
        return response()->json($return);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->productBrand->fields(), $request->all());

        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $response = $this->productBrand->fill($request->all());


            if ($request->uuid == '') :
                $uuid = Str::uuid();
                $response->uuid = $uuid;
            endif;

            if (!isset($request->slug) || empty($request->slug)) :
                $response->slug = Helpers::slugfy($response->title);
            endif;

            $verifySlug = $this->productBrand->where('slug', '=', $response->slug)->get();

            if (sizeof($verifySlug) != 0) :
                $return["message"] = "Slug ja cadastrado";
            else :
                if ($request->has('thumbnail')) :
                    $thumbnail = $request->file('thumbnail');
                    $thumbnail_urn = $thumbnail->store('productsBrands', 'public');
                    $response->thumbnail = $thumbnail_urn;
                endif;
                if ($response->save()) :
                    $return['success'] = true;
                    $return['product_brand'] = $response;
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Product_brand  $Product_brand
     * @return \Illuminate\Http\Response
     */
    public function show($param)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->productBrand->where('uuid', '=', $param)->orWhere('slug', '=', $param)->get();
        if (sizeof($response) == 0) :
            $return['errors'] = "Product Brand não encontrado";
        else :
            $return['success'] = true;
            $return['product_brand'] = $response[0];
        endif;
        return response()->json($return);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Product_brand  $Product_brand
     * @return \Illuminate\Http\Response
     */
    public function edit(Product_brand $Product_brand)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Product_brand  $Product_brand
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $uuid)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->productBrand->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $productBrand = $this->productBrand->where('uuid', '=', $uuid)->get();
            if (sizeof($productBrand) == 0) :
                $return['message'] = 'Product brand não encontrado';
            else :

                $response = $productBrand[0]->fill($request->except('thumbnail'));


                if (!isset($request->slug) || empty($request->slug)) :
                    $response->slug = Helpers::slugfy($request->title);
                endif;

                $verifySlug = Product_brand::where('slug', '=', $response->slug)->where('uuid', '<>', $response->uuid)->get();

                if (sizeof($verifySlug) > 0) :
                    $return["message"] = "Slug ja cadastrado";
                else :
                    if ($request->file('thumbnail')) {
                        Storage::disk('public')->delete($response->thumbnail);
                        $thumbnail = $request->file('thumbnail');
                        $thumbnail_urn = $thumbnail->store('productsBrands', 'public');
                        $response->thumbnail = $thumbnail_urn;
                    }
                    if ($response->save()) {
                        $return['success'] = true;
                        $return['product_brand'] = $response;
                    }
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Product_brand  $Product_brand
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product_brand $Product_brand)
    {
        //
    }
}
