<?php

namespace App\Http\Controllers;

use App\Models\Product_category;
use EDGVI10\Helpers;
use Illuminate\Http\Request;
use illuminate\Support\Str;
use App\Repositories\ProductCategoryRepository;
use Illuminate\Support\Facades\Storage;

class ProductCategoryController extends Controller
{
    public function __construct(Product_category $productCategory)
    {
        $this->productCategory = $productCategory;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $productCategoryRepository = new ProductCategoryRepository($this->productCategory);

        if ($request->has('request_attributes')) :
            $productCategoryRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $productCategoryRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $productCategoryRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $productCategoryRepository->getResult('products_categories', $request->paginate);
        else :
            $return = $productCategoryRepository->getResult('products_categories', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->productCategory->fields(), $request->all());

        if ($confirmation != 'true') {
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        } else {
            $response = $this->productCategory->fill($request->all());

            if ($request->has('thumbnail')) :
                $thumbnail = $request->file('thumbnail');
                $thumbnail_urn = $thumbnail->store('productsCategories', 'public');
                $response->thumbnail = $thumbnail_urn;
            endif;

            if ($request->uuid == '') {
                $uuid = Str::uuid();
                $response->uuid = $uuid;
            }

            if (!isset($request->slug) || empty($request->slug)) {
                $response->slug = Helpers::slugfy($response->title);
            }

            $verifySlug = $this->productCategory->where('slug', '=', $response->slug)->get();

            if (sizeof($verifySlug) != 0) :
                $return["message"] = "Slug ja cadastrado";
            else :
                if ($response->save()) :
                    $return['success'] = true;
                    $return['product_category'] = $response;
                endif;
            endif;
        }
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Product_category  $Product_category
     * @return \Illuminate\Http\Response
     */
    public function show($param)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->productCategory->where('uuid', '=', $param)->orWhere('slug', '=', $param)->get();
        if (sizeof($response) == 0) :
            $return['errors'] = "Prudct category não encontrado";
        else :
            $return['success'] = true;
            $return['product_category'] = $response[0];
        endif;
        return response()->json($return);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Product_category  $Product_category
     * @return \Illuminate\Http\Response
     */
    public function edit(Product_category $Product_category)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Product_category  $Product_category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $uuid)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->productCategory->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $productCategory = $this->productCategory->where('uuid', '=', $uuid)->get();
            if (sizeof($productCategory) == 0) :
                $return['message'] = 'Product category não encontrado';
            else :

                $response = $productCategory[0]->fill($request->except('thumbnail'));


                if (!isset($request->slug) || empty($request->slug)) :
                    $response->slug = Helpers::slugfy($request->title);
                endif;

                $verifySlug = Product_category::where('slug', '=', $response->slug)->where('uuid', '<>', $response->uuid)->get();

                if (sizeof($verifySlug) > 0) :
                    $return["message"] = "Slug ja cadastrado";
                else :
                    if ($request->file('thumbnail')) {
                        Storage::disk('public')->delete($productCategory[0]->thumbnail);
                        $thumbnail = $request->file('thumbnail');
                        $thumbnail_urn = $thumbnail->store('productsCategories', 'public');
                        $response->thumbnail = $thumbnail_urn;
                    }
                    if ($response->save()) {
                        $return['success'] = true;
                        $return['product_category'] = $response;
                    }
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Product_category  $Product_category
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product_category $Product_category)
    {
        //
    }
}
