<?php

namespace App\Http\Controllers;

use App\Models\Product;
use EDGVI10\Helpers;
use Illuminate\Http\Request;
use illuminate\Support\Str;
use App\Repositories\ProductRepository;
use Illuminate\Support\Facades\Storage;

class ProductController extends Controller
{
    public function __construct(Product $product)
    {
        $this->product = $product;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $productRepository = new ProductRepository($this->product);

        if ($request->has('request_attributes')) :
            $productRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $productRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $productRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $productRepository->getResult('products', $request->paginate);
        else :
            $return = $productRepository->getResult('products', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->product->fields(), $request->all());

        if ($confirmation != 'true') {
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        } else {
            $response = $this->product->fill($request->all());


            if ($request->uuid == '') {
                $uuid = Str::uuid();
                $response->uuid = $uuid;
            }

            if (!isset($request->slug) || empty($request->slug)) {
                $response->slug = Helpers::slugfy($response->title);
            }

            $verifySlug = $this->product->where('slug', '=', $response->slug)->get();

            if (sizeof($verifySlug) != 0) :
                $return["message"] = "Slug ja cadastrado";
            else :
                if ($request->has('thumbnail')) :
                    $thumbnail = $request->file('thumbnail');
                    $thumbnail_urn = $thumbnail->store('productsDepartments', 'public');
                    $response->thumbnail = $thumbnail_urn;
                endif;
                if ($response->save()) :
                    $return['success'] = true;
                    $return['product'] = $response;
                endif;
            endif;
        }
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Product  $Product
     * @return \Illuminate\Http\Response
     */
    public function show($param)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->product->where('uuid', '=', $param)->orWhere('slug', '=', $param)->get();
        if (sizeof($response) == 0) :
            $return['errors'] = "Product não encontrado";
        else :
            $return['success'] = true;
            $return['product'] = $response[0];
        endif;
        return response()->json($return);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Product  $Product
     * @return \Illuminate\Http\Response
     */
    public function edit(Product $Product)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Product  $Product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $uuid)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->product->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $product = $this->product->where('uuid', '=', $uuid)->get();
            if (sizeof($product) == 0) :
                $return['message'] = 'Product não encontrado';
            else :

                $response = $product[0]->fill($request->except('thumbnail'));


                if (!isset($request->slug) || empty($request->slug)) :
                    $response->slug = Helpers::slugfy($request->title);
                endif;

                $verifySlug = Product::where('slug', '=', $response->slug)->where('uuid', '<>', $response->uuid)->get();

                if (sizeof($verifySlug) > 0) :
                    $return["message"] = "Slug ja cadastrado";
                else :
                    if ($request->file('thumbnail')) {
                        Storage::disk('public')->delete($response->thumbnail);
                        $thumbnail = $request->file('thumbnail');
                        $thumbnail_urn = $thumbnail->store('productsDepartments', 'public');
                        $response->thumbnail = $thumbnail_urn;
                    }
                    if ($response->save()) {
                        $return['success'] = true;
                        $return['product'] = $response;
                    }
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Product  $Product
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $Product)
    {
        //
    }
}
