<?php

namespace App\Http\Controllers;

use App\Models\Product_department;
use EDGVI10\Helpers;
use Illuminate\Http\Request;
use illuminate\Support\Str;
use App\Repositories\ProductDepartmentRepository;
use Illuminate\Support\Facades\Storage;

class ProductDepartmentController extends Controller
{
    public function __construct(Product_department $productDepartment)
    {
        $this->productDepartment = $productDepartment;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $productDepartmentRepository = new ProductDepartmentRepository($this->productDepartment);

        if ($request->has('request_attributes')) :
            $productDepartmentRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $productDepartmentRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $productDepartmentRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $productDepartmentRepository->getResult('products_departments', $request->paginate);
        else :
            $return = $productDepartmentRepository->getResult('products_departments', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->productDepartment->fields(), $request->all());

        if ($confirmation != 'true') {
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        } else {
            $response = $this->productDepartment->fill($request->all());
            if ($request->uuid == '') {
                $uuid = Str::uuid();
                $response->uuid = $uuid;
            }

            if (!isset($request->slug) || empty($request->slug)) {
                $response->slug = Helpers::slugfy($response->title);
            }

            $verifySlug = $this->productDepartment->where('slug', '=', $response->slug)->get();

            if (sizeof($verifySlug) != 0) :
                $return["message"] = "Slug ja cadastrado";
            else :
                if ($request->has('thumbnail')) :
                    $thumbnail = $request->file('thumbnail');
                    $thumbnail_urn = $thumbnail->store('productsDepartments', 'public');
                    $response->thumbnail = $thumbnail_urn;
                endif;
                if ($response->save()) :
                    $return['success'] = true;
                    $return['product_department'] = $response;
                endif;
            endif;
        }
        return response()->json($return);
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Product_department  $Product_department
     * @return \Illuminate\Http\Response
     */
    public function show($param)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->productDepartment->where('uuid', '=', $param)->orWhere('slug', '=', $param)->get();
        if (sizeof($response) == 0) :
            $return['errors'] = "Product department não encontrado";
        else :
            $return['success'] = true;
            $return['product_department'] = $response[0];
        endif;
        return response()->json($return);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Product_department  $Product_department
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $uuid)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->productDepartment->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $productDepartment = $this->productDepartment->where('uuid', '=', $uuid)->get();
            if (sizeof($productDepartment) == 0) :
                $return['message'] = 'Product department não encontrado';
            else :
                $response = $productDepartment[0]->fill($request->except('thumbnail'));
                if (!isset($request->slug) || empty($request->slug)) :
                    $response->slug = Helpers::slugfy($request->title);
                endif;

                $verifySlug = Product_department::where('slug', '=', $response->slug)->where('uuid', '<>', $response->uuid)->get();

                if (sizeof($verifySlug) > 0) :
                    $return["message"] = "Slug ja cadastrado";
                else :
                    if ($request->file('thumbnail')) {
                        Storage::disk('public')->delete($response->thumbnail);
                        $thumbnail = $request->file('thumbnail');
                        $thumbnail_urn = $thumbnail->store('productsDepartments', 'public');
                        $response->thumbnail = $thumbnail_urn;
                    }
                    if ($response->save()) {
                        $return['success'] = true;
                        $return['product_department'] = $response;
                    }
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Product_department  $Product_department
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product_department $Product_department)
    {
        //
    }
}
