<?php

namespace App\Http\Controllers;
use EDGVI10\Helpers;
use App\Models\_siteinfo;
use Illuminate\Http\Request;
use App\Repositories\_SiteinfoRepository;

class SiteinfoController extends Controller
{ 
    public function __construct(_siteinfo $siteinfo) {
    $this->siteinfo = $siteinfo;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $siteinfoRepository = new _SiteinfoRepository($this->siteinfo);

        if ($request->has('request_attributes')) :
            $siteinfoRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $siteinfoRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $siteinfoRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $siteinfoRepository->getResult('siteinfo', $request->paginate);
        else :
            $return = $siteinfoRepository->getResult('siteinfo', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $confirmation = Helpers::requiredTest($this->siteinfo->fields(), $request->all());
        
        if($confirmation != 'true'){
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        }else{
            $response = $this->siteinfo->create($request->all());
            if($response){
                $return["success"] = true;
                $return["site_info"] = $response;
            }
        }
        return response()->json($return);
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\_siteinfo  $_siteinfo
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $return = [];
        $return['success'] = false;

        $response = $this->siteinfo->find($id);
        if ($response === null) :
            $return['errors'] = "Post meta não encontrado";
        else :
            $return['success'] = true;
            $return['post'] = $response;
        endif;
        return response()->json($return);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\_siteinfo  $_siteinfo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $return = [];
        $return['success'] = false;

        $confirmation = Helpers::requiredTest($this->siteinfo->fields(), $request->all());
        if ($confirmation != 'true') :
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $confirmation;
        else :
            $response = $this->siteinfo->find($id);

            if ($response === null) :
                $return['errors'] = "Post meta não encontrado";
            else :
                $response->fill($request->all());
                if ($response->save()) {
                    $return['success'] = true;
                    $return['post_category'] = $response;
                }
            endif;
        endif;

        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\_siteinfo  $_siteinfo
     * @return \Illuminate\Http\Response
     */
    public function destroy(_siteinfo $_siteinfo)
    {
        //
    }
}
