<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use illuminate\Support\Str;
use EDGVI10\Helpers;
use App\Repositories\UserRepository;

class UserController extends Controller
{

    public function __construct(User $user)
    {
        $this->user = $user;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $userRepository = new UserRepository($this->user);

        if ($request->has('request_attributes')) :
            $userRepository->selectAtributos($request->request_attributes);
        endif;

        if ($request->has('request_filters')) :
            $userRepository->filter($request->request_filters);
        endif;

        if ($request->has('limit')) :
            $userRepository->addLimit($request->limit);
        endif;

        if ($request->has('paginate')) :
            $return = $userRepository->getResult('users', $request->paginate);
        else :
            $return = $userRepository->getResult('users', false);
        endif;
        return response()->json($return);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return = [];
        $return["success"] = false;

        $validation = Helpers::requiredTest($this->user->fields(), $request->all());
        $phone = Helpers::phonemask($request->phone);

        if ($validation != 'true') {
            $return["message"] = "Faltam campos obrigatórios";
            $return["errors"] = $validation;
        } else {

            $emailValidation = Helpers::validEmail($request->email);
            if (!$emailValidation) {
                $return["message"] = "Email não é válido";
            }
            if (strlen($request->password) < 8) {
                $return["message"] = "Senha precisa ter mais de 8 digitos";
            }
            $response = $this->user->fill($request->all());
            if ($request->uuid == '') {
                $uuid = Str::uuid();
                $response->uuid = $uuid;
            }
            $response->name = Helpers::capitalize($request->name);
            $response->nickname = $request->nickname ?? Helpers::getName($response->name);
            $response->phone = $phone;
            $response->password = md5($request->password);
            if ($response->save()) {
                $return["success"] = true;
                $return["user_data"] = $response;
            }
        }
        return response()->json($return);
    }

    /**
     * Display the specified resource.
     *
     * @param  string  $uuid
     * @return \Illuminate\Http\Response
     */
    public function show($uuid)
    {
        $return = [];
        $return['success'] = false;
        $response = $this->user->where('uuid', '=', $uuid)->get();
        //return response()->json($response);
        if (sizeof($response) == 0) :
            $return['errors'] = "User não encontrado";
        else :
            $return['success'] = true;
            $return['user'] = $response[0];
        endif;

        return response()->json($return);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $uuid)
    {
        $return = [];
        $return["success"] = false;

        $validation = Helpers::requiredTest($this->user->fields(), $request->all());

        if ($validation != 'true') {
            return response()->json($validation);
        }
        $response = $this->user->where('uuid', '=', $uuid)->get();

        if (sizeof($response) == 0) :
            $return['message'] = 'Usuário não encontrado';
        else :
            $emailValidation = Helpers::validEmail($request->email);
            if (!$emailValidation || strlen($request->password) < 8) :
                $return['message'] = 'Campos inválidos';
                if (!$emailValidation) :
                    $return['errors']['email'] = 'Email inválido';
                endif;

                if (strlen($request->password) < 8) :
                    $return['errors']['password'] = 'Senha precisa ter mais de 8 digitos';
                endif;
            else :
                $response[0]->fill($request->all());
                if ($request->has("phone")) :
                    $phone = Helpers::phonemask($request->phone);
                    $response[0]->phone = $phone;
                endif;
                if ($response[0]->save()) :
                    $return["users"] = $response[0];
                endif;
            endif;
        endif;
        return response()->json($return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
