<?php

namespace App\Repositories;

use Illuminate\Database\Eloquent\Model;


abstract class AbstractRepository
{
    public function __construct(Model $model)
    {
        $this->model = $model;
    }

    public function filter($filtros, $separator = ";")
    {
        $filtros = explode($separator, $filtros);
        foreach ($filtros as $key => $condicao) {
            $c = explode('||', $condicao);
            $this->model = $this->model->where($c[0], $c[1], $c[2]);
        }
    }

    public function selectAtributos($atributos)
    {
        $this->model = $this->model->selectRaw($atributos);
    }

    public function addLimit($limit)
    {
        $this->model = $this->model->limit($limit);
    }

    public function getResult($model, $paginate)
    {
        $return = [];
        $return["success"] = false;
        if ($paginate) :
            if (!$response = $this->model->paginate(intval($paginate))) :
                $return["message"] = "Falha ao buscar os $model's'";
            elseif (sizeof($response) == 0) :
                $return["message"] = "Nenhum $model cadastrado";
            else :
                $return[$model] = $response;
            endif;
            return $return;
        else :
            if (!$response = $this->model->get()) :
                $return["message"] = "Falha ao buscar os $model's'";
            elseif (sizeof($response) == 0) :
                $return["message"] = "Nenhum $model cadastrado";
            else :
                $posts = [];
                foreach ($response as $post) :
                    //if ($post->created_at) $post->createdAt = Helpers::timemask($post->created_at);
                    $posts[] = $post;
                endforeach;
                $return["success"] = true;
                $return[$model] = $posts;
            endif;
            return $return;
        endif;
    }
}
