<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id()->unique();
            $table->uuid('uuid', 36)->unique();
            $table->string('name', 150);
            $table->string('nickname', 60);
            $table->string('email', 200);
            $table->string('phone', 15)->nullable();
            $table->string('username', 250);
            $table->string('password', 200);
            $table->tinyInteger('active')->default(1)->nullable();
            $table->timestamps();
            $table->timestamp('blocked_at')->nullable();
            $table->timestamp('deleted_at')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
