<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNavigationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('_navigations', function (Blueprint $table) {
            $table->id()->unique();
            $table->uuid('uuid', 36)->unique();
            $table->integer('parent_id')->nullable();
            $table->integer('order')->nullable();
            $table->tinyInteger('external')->default(0);
            $table->string('position', 30);
            $table->string('label', 50);
            $table->string('url', 255);
            $table->text('description')->nullable();
            $table->string('class', 100)->nullable();
            $table->string('icon', 100)->nullable();
            $table->tinyInteger('active')->default(1);
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('_navigations');
    }
}
