<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid', 36)->unique();
            $table->string('type', 20);
            $table->integer('order')->nullable();
            $table->string('parent_uuid', 36)->nullable();
            $table->string('author_uuid', 36)->nullable();
            $table->string('title', 200);
            $table->string('slug', 200)->unique();
            $table->text('excerpt')->nullable();
            $table->longText('content')->nullable();
            $table->text('thumbnail')->nullable();
            $table->string('language', 20)->nullable();
            $table->string('layout', 20)->nullable();
            $table->text('category_id')->nullable();
            $table->text('css_style')->nullable();
            $table->tinyInteger('active')->default(1);
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('posts');
    }
}
