<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsDepartmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products_departments', function (Blueprint $table) {
            $table->id()->unique();
            $table->uuid('uuid', 36)->unique();
            $table->integer('order')->nullable();
            $table->integer('local_id')->default(0);
            $table->string('parent_uuid', 36)->nullable();
            $table->string('title', 60);
            $table->string('slug', 60)->unique();
            $table->text('excerpt')->nullable();
            $table->text('content')->nullable();
            $table->string('read_more', 25)->nullable();
            $table->text('banner')->nullable();
            $table->text('thumbnail')->nullable();
            $table->text('css_style')->nullable();
            $table->tinyInteger('active')->default(1);
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products_departments');
    }
}
