<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid', 36)->unique();
            $table->string('barcode', 36);
            $table->string('title', 150);
            $table->string('slug', 250)->unique();
            $table->text('excerpt');
            $table->text('description')->nullable();
            $table->text('thumbnail')->nullable();
            $table->integer('department_id')->nullable();
            $table->integer('category_id')->nullable();
            $table->integer('brand_id')->nullable();
            $table->double('unit_price', 10, 4)->nullable();
            $table->string('unit_pkg', 20)->nullable();
            $table->string('unit_pkgabbr', 20)->nullable();
            $table->tinyInteger('active')->default(1);
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
