<?php

use App\Http\Controllers\NavigationController;
use App\Models\_navigation;
use App\Models\_siteinfo;
use App\Models\Post;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::apiResource('users', 'App\Http\Controllers\UserController');
Route::apiResource('nav', 'App\Http\Controllers\NavigationController');
Route::apiResource('siteinfo', 'App\Http\Controllers\SiteinfoController');
Route::apiResource('post/types', 'App\Http\Controllers\PostTypeController');
Route::apiResource('posts/metas', 'App\Http\Controllers\PostMetaController');
Route::apiResource('posts/categories', 'App\Http\Controllers\PostCategoryController');
// Route::get('posts/:id', 'App\Http\Controllers\PostCategoryController@getBySlug');
Route::apiResource('posts', 'App\Http\Controllers\PostController');
Route::apiResource('products/brands', 'App\Http\Controllers\ProductBrandController');
Route::apiResource('products/departments', 'App\Http\Controllers\ProductDepartmentController');
Route::apiResource('products/categories', 'App\Http\Controllers\ProductCategoryController');
Route::apiResource('products', 'App\Http\Controllers\ProductController');

Route::prefix("frontend")->group(function () {
    Route::get("/siteinfo", function () {
        $siteinfo_raw = _siteinfo::where("active", "=", 1)->get();

        $siteinfo = [];
        foreach ($siteinfo_raw as $info) :
            $siteinfo[$info["key"]] = $info["value"];
        endforeach;
        return response()->json($siteinfo);
    });

    Route::get("/navs/{position}", function ($position) {
        $nc = new NavigationController(new _navigation);
        $items = $nc->getNavItems(["position" => $position]);

        return response()->json($items);
    });

    Route::get("/page/{page_slug}", function ($page_slug, Request $request) {
        $page = Post::where("active", "=", 1)->where("type", "=", $request->type)->where("slug", "=", $page_slug)->get()[0] ?? null;

        $page_data = null;
        if ($page !== null) :
            $page_data = (object) [];
            $page_data->title = $page["title"];
            $page_data->slug = $page["slug"];
            $page_data->excerpt = $page["excerpt"];
            $page_data->content = $page["content"];
            $page_data->thumbnail = $page["thumbnail"];
            $page_data->language = $page["language"];
            $page_data->layout = $page["layout"];
            $page_data->css_style = $page["css_style"];
            if ($page->author_uuid !== null) $page_data->author = User::where("uuid", "=", $page->author_uuid)->get("name", "nickname", "email", "phone", "username")[0];

            $page_data->created_at = $page["created_at"];
            $page_data->updated_at = $page["updated_at"];
        endif;
        return response()->json($page_data);
    });

    Route::get("/page", function () {
        $pages = Post::where("active", "=", 1)->where("type", "=", "page")->get() ?? null;
        $page_data = null;
        $pages_data = array();
        if ($pages !== null) :
            $page_data = (object) [];
            foreach ($pages as $key => $page) {
                $page_data->title = $page["title"];
                $page_data->slug = $page["slug"];
                $page_data->excerpt = $page["excerpt"];
                $page_data->content = $page["content"];
                $page_data->thumbnail = $page["thumbnail"];
                $page_data->language = $page["language"];
                $page_data->layout = $page["layout"];
                $page_data->css_style = $page["css_style"];
                if ($page->author_uuid !== null) $page_data->author = User::where("uuid", "=", $page->author_uuid)->get("name", "nickname", "email", "phone", "username")[0];

                $page_data->created_at = $page["created_at"];
                $page_data->updated_at = $page["updated_at"];

                $pages_data[] = $page_data;
            }
        endif;
        return response()->json($pages);
    });
});
