<?php

namespace LinkApps;

use \LinkApps\Helpers as Helper;
use \LinkApps\DBWalker as DB;

class OrderController
{
    const select_query = [
        "table" => "orc_link.tab_pedido AS orders",
        "columns" => [
            "orders.numero_pedido AS number",
            "orders.cupom AS nf_number",
            "orders.numentrega AS delivery_id",
            "orders.dataentrega AS delivery_date",
            "orders.statusrota AS delivery_status",
            "orders.obsentrega AS delivery_info",
            "(orders.entrega) AS delivered",

            "orders.prioridade AS prioridade",

            "orders.codigo_cliente AS client_id",
            "orders.cliente AS client_name",
            "client.tel1 as client_phone",

            "'' AS delivery_address",
            "client.endereco AS address",
            "client.bairro AS neighborhood",
            "client.cidade AS city",
            "client.estado AS state",
            "client.cep AS cep",

            "orders.vendedor AS seller",

            "client.usaendent AS use_delivery_address",
            "client.end_ent AS address_delivery",
            "client.bairro_ent AS neighborhood_delivery",
            "client.cidade_ent AS city_delivery",
            "client.estado_ent AS state_delivery",
            "client.cep_ent AS cep_delivery",

            "`CODIGO_BARRAS` AS product_barcode",
            "`PRODUTO` AS product_name",
            "`QTD_ITEM` AS product_amount",
            "`ENTREGA` AS product_delivered",

            "CONCAT(client.latitude, ',', client.longitude) AS location",
        ],
        "joins" => [
            ["LEFT", "orc_link.clientes AS client", "CAST(orders.codigo_cliente AS SIGNED) = CAST(client.codigo_cliente AS SIGNED)"]
        ],
        // "group_by" => "orders.numero_pedido",
        "order_by" => "orders.prioridade < 1, orders.prioridade",
    ];

    public static function format($order)
    {
        $order->number = $order->number;
        $order->nf_number = $order->nf_number ?? "--";
        $order->client_id = (int) $order->client_id;

        $order->route_id = (int) $order->route_id;
        $order->delivery_id = (int) $order->delivery_id;

        $order->delivered = ($order->delivered === null) ? null : (bool) $order->delivered;

        $order->status = "Não iniciada";
        if ($order->delivered)
            $order->status = "Concluída";
        elseif (!$order->delivered && $order->delivery_info !== null)
            $order->status = "Cancelada";

        $order->use_delivery_address = (bool) $order->use_delivery_address;

        $order->cep = Helpers::extractInt($order->cep);
        $order->cep_delivery = Helpers::extractInt($order->cep_delivery);

        $products = [];
        // $product_barcodes = explode("||", $order->product_barcodes);
        // $product_names = explode("||", $order->product_names);
        // $product_amounts = explode("||", $order->product_amounts);
        // $product_delivered = explode("||", $order->product_delivered);
        $i = 0;

        // unset(
        //     $order->product_delivered,
        //     $order->product_barcodes,
        //     $order->product_amounts,
        //     $order->product_names,
        // );

        // $order->products = $products;

        if ($order->use_delivery_address) :
            $order->delivery_address = Helpers::capitalize($order->address_delivery);
            $order->delivery_address .= " - " . Helpers::capitalize($order->neighborhood_delivery);
            $order->delivery_address .= ", " . Helpers::capitalize($order->city_delivery);
            $order->delivery_address .= " (" . strtoupper($order->state_delivery) . ")";
        else :
            $order->delivery_address = Helpers::capitalize($order->address);
            $order->delivery_address .= " - " . Helpers::capitalize($order->neighborhood);
            $order->delivery_address .= ", " . Helpers::capitalize($order->city);
            $order->delivery_address .= " (" . strtoupper($order->state) . ")";
        endif;

        $order->client_phone = [
            "text" => Helper::phonemask($order->client_phone) ?? "--",
            "value" => $order->client_phone ?? null
        ];

        $order->delivery_date = implode("-", array_reverse(explode("/", $order->delivery_date)));

        $order->can_cancel = false;
        $order->can_finish = false;

        if ($order->delivered === false || $order->delivered === null) $order->can_finish = true;
        if ($order->delivered === true || $order->delivered === null || $order->delivery_info == null) $order->can_cancel = true;

        unset($order->address, $order->neighborhood, $order->city, $order->state);
        unset($order->address_delivery, $order->neighborhood_delivery, $order->city_delivery, $order->state_delivery);

        return $order;
    }

    public static function store($data, $id = null)
    {
    }

    public static function cancel($request, $response, $args)
    {
        $data = $request->getParsedBody();
        $slug = $args["client"];
        $number = $args["number"];
        $mysql_access = (new Helper)->getEmpresa($slug);

        $db = new DB($mysql_access);

        $update["table"] = "orc_link.tab_pedido";
        $update["data"]["obsentrega"] = $data["reason"];
        $update["data"]["entrega"] = 0;
        $update["where"]["numero_pedido"] = $data["order_id"];

        $return = $db->update($update, true);

        $log["table"] = "baselink.log_sistema";
        $log["data"]["data"] = date("Y-m-d");
        $log["data"]["hora"] = date("H:i:s");
        $log["data"]["usuario"] = $data["user"];
        $log["data"]["operacao"] = "botao_cancelar - {$data["order_id"]}";
        $log["data"]["tela"] = "App Entrega";
        $log["data"]["motivo"] = $data["reason"];

        $log = $db->insert($log);

        return $response->withJson($return, 200);
    }

    public static function finish($request, $response, $args)
    {
        $data = $request->getParsedBody();
        $slug = $args["client"];
        $number = $args["number"];
        $mysql_access = (new Helper)->getEmpresa($slug);

        $db = new DB($mysql_access);

        $update["table"] = "orc_link.tab_pedido";
        $update["data"]["obsentrega"] = $data["reason"];
        $update["data"]["entrega"] = 1;
        $update["where"]["numero_pedido"] = $data["order_id"];

        $return = $db->update($update, true);

        $log["table"] = "baselink.log_sistema";
        $log["data"]["data"] = date("Y-m-d");
        $log["data"]["hora"] = date("H:i:s");
        $log["data"]["usuario"] = $data["user"];
        $log["data"]["operacao"] = "botao confirmar entrega - {$data["order_id"]}";
        $log["data"]["tela"] = "App Entrega";
        $log["data"]["motivo"] = $data["reason"];

        $log = $db->insert($log);

        return $response->withJson($return, 200);
    }

    public static function get(array $args = [])
    {
        $return["success"] = true;
        $slug = $args["client"];

        $type = false;
        if (isset($args["order_number"])) :
            $number = Helper::extractInt($args["order_number"]);

            switch (strlen($number)):
                case 44:
                    $type = "accesskey";
                    break;
                case 10:
                    $type = "order";
                    break;
                case 9:
                    $type = "nf";
                    break;
            endswitch;

        elseif (isset($args["route_number"])) :
            $number = Helper::extractInt($args["route_number"]);

            $type = "route";
        endif;

        if (!$type) return ["success" => false, "message" => "Número não identificado"];

        $mysql_access = Helper::getEmpresa($slug);

        $db = new DB($mysql_access);

        $select_order = self::select_query;

        $return["number"] = $number;
        $return["type"] = $type;

        if ($type === "accesskey") :
            $serie = substr($number, 22, 3);
            $nf = substr($number, 25, 9);

            $return["nfe"]["uf"] = substr($number, 0, 2);
            $return["nfe"]["AAMM"] = Helper::mask("##.##", substr($number, 2, 4));
            $return["nfe"]["serie"] = $serie;
            $return["nfe"]["nf"] = $nf;
            $return["nfe"]["cnpj"] = Helper::mask("##.###.###/####-##", substr($number, 6, 14));

            $select_order["where"][] = "orders.cupom = '{$nf}'";
        elseif ($type === "order") :
            $return["pedido"]["vendedor"] = substr($number, 0, 2);
            $return["pedido"]["numero"] = $number;
            $select_order["where"][] = "orders.numero_pedido = '{$number}'";
        // $select_order["where"][] = "pedido.cupom = '{$nf}'";
        elseif ($type === "nf") :
            $return["pedido"]["numero"] = $number;
            $select_order["where"][] = "orders.cupom = '{$number}'";
        elseif ($type === "route") :
            $return["pedido"]["numero"] = $number;
            $select_order["where"][] = "orders.numentrega = '{$number}'";
        endif;
        $select_order["where"][] = "orders.cancelado = '0'";

        $select_order = $db->select($select_order);

        $return["success"] = $select_order["success"];
        // $return["debug"] = $select_order;

        if ($select_order["success"]) :
            $rows = [];

            $rows_raw = $select_order["data"];
            $products = [];
            foreach ($rows_raw as $row) :
                $row = self::format($row);

                $products[$row->number][$row->product_barcode] = [
                    "barcode" => $row->product_barcode,
                    "name" => $row->product_name,
                    "amount" => (float) $row->product_amount,
                    "delivered" => (bool) $row->product_delivered
                ];

                $rows[$row->number] = $row;
            endforeach;

            $orders = [];
            foreach ($rows as $row) :
                $order = $row;

                $order->products = $products[$row->number];

                $orders[] = $order;
            endforeach;

            $return["success"] = true;
            // $return["results"] = $select_order["results"];
            $return["data"] = $orders;

        // exit(json_encode($return));
        endif;

        // $return["query"] = $select_order;

        return $return;
    }
}
