<?php

use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

use \LinkApps\Helpers as Helper;
use \LinkApps\DBWalker as DB;

use \LinkApps\Products as Product;

require __DIR__ . "/../vendor/autoload.php";

setlocale(LC_TIME, 'pt_BR', 'pt_BR.iso-8859-1', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

// header("Access-Control-Allow-Origin: *");
// header("Access-Control-Allow-Headers: *");

$config = ["settings" => ["displayErrorDetails" => true]];

$app = new \Slim\App($config);

$app->add(function ($request, $response, $next) {
    $headers = $request->getHeaders();
    foreach ($headers as $name => $values)
        $headers[$name] = implode(", ", $values);

    $return = [];
    $return["headers"] = $headers;

    // $token = trim($headers["HTTP_JWT"]);

    $response = $next($request, $response);

    return $response
        ->withHeader('Access-Control-Allow-Origin', '*')
        ->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization, JWT')
        ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
});

$app->get('[/]', function (Request $request, Response $response, array $args) {
    $return = [];
    $return["succes"] = true;
    $return["version"] = "1.0";

    return $response->withJson($return, 200);
});

$app->post('/util', function (Request $request, Response $response, array $args) {
    $data = $request->getParsedBody();
    $return = [];
    $return["succes"] = true;

    $return["data"] = $data;

    $keys = ["R1c0Ch3T3", "B3rmud4"];

    if (isset($data["base64"])) :
        $base64 = base64_decode(str_replace("B3rmud4", "", $data["base64"]));
        $base64 = base64_decode(str_replace("R1c0Ch3T3", "", $data["base64"]));
        $return["base64"] = $base64;
    endif;

    if (isset($data["textTobase64"])) :
        $textTobase64 = $keys[round(count($keys) - 1)] . Helper::base64url_encode($data["textTobase64"]);
        $return["textTobase64"] = $textTobase64;
    endif;

    return $response->withJson($return, 200);
});

$app->group("/{client}", function ($app) {
    $app->get('[/]', function (Request $request, Response $response, array $args) {
        $return = [];
        $return["succes"] = true;
        $return["version"] = "1.0";
        $return["client"] = $args["client"];

        $slug = $args["client"];
        $mysql_access = (new Helper)->getEmpresa($slug);
        $db = new DB($mysql_access);

        return $response->withJson($return, 200);
    });

    $app->group("/{user}", function ($app) {
        include __DIR__ . "/../Routes/routes.php";
    });

    // include __DIR__ . "/../Routes/endpoints.php";
    include __DIR__ . "/../Routes/login.php";

    include __DIR__ . "/../Routes/delivery.php";
});

// Run application
$app->run();
