<?php

use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

use \LinkApps\OptionsAddress as Address;
use \LinkApps\Helpers as Helper;
use \LinkApps\DBWalker as DB;
use LinkApps\Helpers;

$app->group("/login", function ($app) {
    $app->post('[/]', function (Request $request, Response $response, array $args) {
        $slug = $args["client"];
        $mysql_access = (new Helper)->getEmpresa($slug);

        $db = new DB($mysql_access);
        $data = $request->getParsedBody();

        $return = [];

        $slug = isset($args["client"]) ? $args["client"] : null;
        $store_id = (isset($data["store_id"]) && !empty($data["store_id"])) ? (new Helper)->extractInt($data["store_id"]) : 1;
        $username = (new Helper)->encript(strtoupper($data["username"]));
        $password = (new Helper)->encript($data["password"]);

        $select_users = $db->select([
            "table" => "`baselink`.`operadores` AS `op`",
            "columns" => [
                "`op`.`CODIGO` AS `code`",
                "`op`.`COD_LOJA` AS `store_code`",
                "`op`.`LOJA` AS `store_name`",
                "`op`.`NOME_OPERADOR` AS `name`",
                "`op`.`NOME_OPERADOR` AS `nickname`",
                "`op`.`COD_FUNCAO` AS `role_code`",
                "`op`.`FUNCAO` AS `role_name`",
                "`op`.`SUPERVISOR` AS `supervisor_name`",
                "`op`.`GERENTE` AS `manager_name`",
            ],
            "where" => [
                // "CAST(op.cod_loja AS SIGNED) = '{$store_id}'",
                "`op`.`NOME` = '{$username}'",
                "`op`.`SENHA` = '{$password}'",
            ],
        ], true);

        if ($select_users["success"]) :
            if (empty($select_users["data"][0])) :
                $return["success"] = false;
                $return["message"] = "Combinação usuário e senha incorreta";
            else :
                $user = $select_users["data"][0];
                $user->name = (new Helper)->capitalize($user->name);
                $user->nickname = (new Helper)->getName($user->name);

                $return["success"] = true;
                $return["data"] = $user;
                $return["token"] = Helpers::base64url_encode(md5($user->code . $slug) . "-" . $user->code . "-" . $user->nickname);
            endif;
        else :
            $return = $select_users;
        endif;

        // $return["debug"] = $select_users;

        if ($return["success"])
            return $response->withJson($return, 202);
        else
            return $response->withJson($return, 200);
    });

    $app->post('/decript', function (Request $request, Response $response, array $args) {
        $data = $request->getParsedBody();

        $return = [];
        $return["success"] = true;
        $return["key"] = (new Helper)->encript($data["key"]);

        if ($return["success"])
            return $response->withJson($return, 200);
        else
            return $response->withJson($return, 200);
    });
});
