<?php

use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

use \LinkApps\DeliveryRouteController as DeliveryRouteController;
use \LinkApps\OrderController as OrderController;
use \LinkApps\Helpers as Helper;
use \LinkApps\DBWalker as DB;

$app->group("/routes", function ($app) {
    $app->get("[/]", function (Request $request, Response $response, array $args) {
        $return = DeliveryRouteController::list($args);

        return $response->withJson($return, 200);
    });

    $app->get("/{route_number}[/]", function (Request $request, Response $response, array $args) {
        $return = DeliveryRouteController::get($args);

        return $response->withJson($return, 200);
    });

    $app->get("/all", function (Request $request, Response $response, array $args) {
        $return = DeliveryRouteController::get($args);

        return $response->withJson($return, 200);
    });

    $app->get("/{route_number}/search", function (Request $request, Response $response, array $args) {
        $return = DeliveryRouteController::get($args);

        return $response->withJson($return, 200);
    });

    $app->put("/{route_number}/{action}/{order_number}", function (Request $request, Response $response, array $args) {
        $data = $request->getParsedBody();
        $return = DeliveryRouteController::updateOrder($args, $data);

        return $response->withJson($return, 200);
    });

    $app->put("/{route_number}/{action}", function (Request $request, Response $response, array $args) {
        $data = $request->getParsedBody();
        $return = DeliveryRouteController::update($args, $data);

        return $response->withJson($return, 200);
    });
});
