<?php

use EDGVI10\DBWalker;
use EDGVI10\Helpers;

class RoutesController
{
    const select_query = [
        "table" => "baselink.tab_entrega AS route",
        "columns" => [
            "route.numentrga AS id",
            "route.numentrga AS delivery_number",
            "route.pedido AS delivery_orders",
            "route.dataentrega AS delivery_date",

            "route.rota AS route_name",

            "route.veiculo AS vehicle",
            "route.placa AS vehicle_plate",

            "route.motorista AS driver",
            "route.ajudante1 AS driver_aide",
            "route.ajudante2 AS driver_aide2",
            "route.carregador AS truckloader",

            "route.kmsaida AS start_km",
            "route.hssaida AS start_time",

            "route.kmretorno AS end_km",
            "route.hsretorno AS end_time",

            "route.obs AS info",

            "route.cancelada AS canceled",
            "route.situacao AS status",
            "route.situacao AS status_id",
        ],
        "order_by" => "id",
    ];

    function __construct($mysql_access)
    {
        $this->mysql_access = $mysql_access;
    }

    public static function format($route, $args = []): object
    {
        $route->args = $args;

        $route->delivery_number = (int) $route->delivery_number;

        $route->delivery_orders = explode(", ", $route->delivery_orders);
        $route->driver = Helpers::capitalize($route->driver);
        $route->driver_aide = (!empty($route->driver_aide)) ? Helpers::getName($route->driver_aide) : null;
        $route->driver_aide2 = (!empty($route->driver_aide2)) ? Helpers::getName($route->driver_aide2) : null;

        $route->truckloader = (!empty($route->truckloader)) ? Helpers::getName($route->truckloader) : null;

        $route->departure["km"] = Helpers::numbermask($route->start_km) ?? 0;
        $route->departure["time"] = date("H:i", strtotime($route->start_time)) ?? "00:00";

        $route->arrive["km"] = Helpers::numbermask($route->end_km) ?? 0;
        $route->arrive["time"] = date("H:i", strtotime($route->end_time)) ?? "00:00";

        $route->canceled = (bool) $route->canceled;
        $route->status_id = $route->status;
        if ($route->canceled) :
            $route->status = "Cancelada";
        else :
            switch ((int) $route->status):
                case 0:
                    $route->status = "Não iniciada";
                    break;
                case 1:
                    $route->status = "Finalizada";
                    break;
                case 2:
                    $route->status = "Iniciada";
                    break;
            endswitch;
        endif;

        unset($route->delivery_orders, $route->start_km, $route->start_time, $route->end_km, $route->end_time);

        $args["route_number"] = $route->delivery_number;
        $select_orders = (object) Order::get($args);

        $finished = 0;

        $orders = [];
        foreach ($select_orders->data as $order) :
            if ($order->delivered) $finished = $finished + 1;
            elseif (!$order->delivered && !empty($order->delivery_info)) $finished = $finished + 1;

            $orders[] = $order;
        endforeach;

        $route->orders = $orders;
        $route->finished_orders = $finished;

        $route->can_finish = false;
        $route->can_start = false;

        if (strtotime($route->delivery_date) < strtotime("+15 days")) :
            $route->can_start = true;
        endif;

        if ($route->finished_orders === count($orders) && $route->status !== 1) $route->can_finish = true;

        return $route;
    }

    public static function update($args, $data)
    {
        $slug = isset($args["client"]) ? $args["client"] : null;
        $user = isset($args["user"]) ? $args["user"] : null;

        $route_number = ltrim(Helpers::extractInt($args["route_number"]), 0);

        $return = [];
        $return["success"] = false;

        $select_route = [];
        $update_route["table"] = "baselink.tab_entrega";
        $update_route["where"] = "tab_entrega.numentrga = '{$route_number}'";

        $doupdate = false;
        if ($args["action"] === "start") :
            if (!isset($data["km"]) || empty($data["km"])) :
                $return["message"][] = "Informe o KM";
            else :
                $km = Helpers::decimal($data["km"]);
                $return["km"] = $km;

                $update_route["data"]["kmsaida"] = $km;
                $update_route["data"]["hssaida"] = date("H:i:s");
                $update_route["data"]["situacao"] = 2;

                $doupdate = true;
            endif;
        elseif ($args["action"] === "stop") :
            $update_route["data"]["situacao"] = 0;

            $doupdate = true;
        elseif ($args["action"] === "finish") :
            if (!isset($data["km"]) || empty($data["km"])) :
                $return["message"][] = "Informe o KM";
            else :
                $km = Helpers::decimal($data["km"]);
                $return["km"] = $km;

                $update_route["data"]["kmretorno"] = $km;
                $update_route["data"]["hsretorno"] = date("H:i:s");
                $update_route["data"]["situacao"] = 1;

                $doupdate = true;
            endif;
        endif;

        if ($doupdate) :
            $db = new DBWalker(self::mysql_access);
            $update_route = (object) $db->update($update_route);

            $return["success"] = $update_route->success;
            $return["affected_rows"] = $update_route->affected_rows;
            if ($update_route->success) :
                $select = self::get($args);
                $return["results"] = $select->results;
                $return["data"] = $select->data;
            endif;
        else :
            $return["message"][] = "Solicitação inválida";
        endif;

        return (object) $return;
    }

    public static function updateOrder($args, $data)
    {
        $slug = isset($args["client"]) ? $args["client"] : null;
        $user = isset($args["user"]) ? $args["user"] : null;

        $order_number = Helpers::extractInt($args["order_number"]);

        $return = [];
        $return["success"] = false;

        $select_route = [];
        $update["table"] = "orc_link.tab_pedido";
        $update["where"] = "tab_pedido.numero_pedido = '{$order_number}'";

        if ($args["action"] === "start") :
            $update["data"]["obsentrega"] = "Entrega Iniciada " . date("d/m/y H:i:s") . " - {$data["reason"]}";
        elseif ($args["action"] === "cancel") :
            $update["data"]["obsentrega"] = "Entrega Cancelada " . date("d/m/y H:i:s") . " - {$data["reason"]}";
            $update["data"]["entrega"] = 0;
        elseif ($args["action"] === "finish") :
            $update["data"]["obsentrega"] = "Entrega Realizada " . date("d/m/y H:i:s") . " - {$data["reason"]}";
            $update["data"]["entrega"] = 1;
        endif;

        $mysql_access = (new Helper)->getEmpresa($slug);
        $db = new DB($mysql_access);
        $update_order = (object) $db->update($update, true);

        $return["success"] = $update_order->success;
        $return["debug"] = $update_order;
        $return["affected_rows"] = $update_order->affected_rows;
        if ($update_order->success) :
            $select = self::get($args);
            $return["results"] = $select->results;
            $return["data"] = $select->data;
        endif;

        return (object) $return;
    }

    public static function get(array $args = [])
    {
        $return = [];
        $return["success"] = false;

        $slug = isset($args["client"]) ? $args["client"] : null;
        $user = isset($args["user"]) ? $args["user"] : null;

        // Converte o número da rota para apenas inteiros
        $route_number = ltrim(Helpers::extractInt($args["route_number"]), 0);

        // Pega a configuração do banco
        $mysql_access = (new Helper)->getEmpresa($slug);
        $db = new DB($mysql_access);

        $select = self::select_query;
        if (!empty($route_number)) $select["where"][] = "route.numentrga = '{$route_number}'";

        $select = (object) $db->select($select);

        $return["debug"] = $select;

        if ($select->success) :
            $return["success"] = $select->success;

            $rows = [];
            $rows_raw = $select->data;
            foreach ($rows_raw as $row) :
                $row = self::format($row, $args);

                $rows[] = $row;
            endforeach;

            $return["results"] = $select->results;
            $return["data"] = $rows;
        endif;

        return (object) $return;
    }
}
