<?php

namespace LinkApps;

set_time_limit(200);

use EDGVI10\Helpers;

class Functions extends Helpers
{
    public static function mysql_access($env)
    {
        if ($env === "linkinfo")
            $env = (array) Helpers::getEnv(__DIR__ . "/../AccessFiles/linkinfo.env");

        foreach ($env as $key => $value)
            if (stripos($key, "mysql_") === 0) $mysql_access[] = $value;

        return $mysql_access;
    }

    public static function getNF($db, $options, $debug = false)
    {
        $table = $options["table"];
        if (empty($table)) return ["error" => "Informe o tipo de documento"];

        $select_docs["table"] = "`{$table}`";
        if ($table === "nfce" || $table === "nfe")
            $select_docs["columns"] = [
                "`data` AS `date`",
                "`key`",
                "`nf`",
                "`xml`",
            ];

        $select_docs["where"]["param_cnpj"] = $options["cnpj"];

        if (isset($options["start"])) :
            $start = date("Y-m-d", strtotime($options["start"]));
            $select_docs["where"]["upperequal_data"] = $start;

            $return["period"][] = $start;
        endif;

        if (isset($options["end"])) :
            $end = date("Y-m-d", strtotime($options["end"]));
            $select_docs["where"]["underequal_data"] = $end;

            $return["period"][] = $end;
        endif;

        if (isset($options["limit"])) $select_docs["limit"] = $options["limit"];
        if (isset($options["offset"])) $select_docs["offset"] = $options["offset"];

        $select_docs = (object) $db->select($select_docs, true);

        if ($debug)
            return $select_docs;

        if (!$select_docs->success) :
            return $select_docs;
        else :
            $return["results"] = $select_docs->results;
            $data = [];
            foreach ($select_docs->data as $doc) :
                // if (!isset($options["download"])) unset($doc->xml);
                $data[] = $doc;
            endforeach;

            $return["data"] = $data;
        endif;

        return (object) $return;
    }

    public static function getNFe($db, $cnpj, $start, $end)
    {

        $select_nfe["table"] = "`NFE`";
        $select_nfe["columns"] = [
            "data AS `date`",
            "chave AS `key`",
            "nf",
            // "xml",
        ];
        $select_nfe["where"]["param_cnpj"] = $cnpj;
        $select_nfe["where"]["between_data"] = [$start, $end];
        // $select_nfce["limit"] = 100;

        $select_nfe = (object) $db->select($select_nfe, true);

        if (!$select_nfe->success)
            return $select_nfe->error;
        else
            return (object) ["period" => [$start, $end], "results" => $select_nfe->results, "data" => $select_nfe->data];
    }
}
