<?php

use \Slim\App as App;
use \Slim\Container;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

use \EDGVI10\Helpers;

require __DIR__ . "/../vendor/autoload.php";
define("ROOT_PATH", __DIR__ . "/../");
define("PUBLIC_PATH", __DIR__ . "/");
define("DEBUG", false);

$baseurl = ($_SERVER["HTTP_HOST"] !== "localhost") ? (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://{$_SERVER["HTTP_HOST"]}/apps/" : null;
define("BASEURL", $baseurl);

setlocale(LC_TIME, 'pt_BR', 'pt_BR.iso-8859-1', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

Helpers::cors();

$config = ["settings" => ["displayErrorDetails" => true]];

$app = new App($config);
$container = new Container;

$app->add(function ($request, $response, $next) {
    $headers = $request->getHeaders();
    foreach ($headers as $name => $values)
        $headers[$name] = implode(", ", $values);

    $return = [];
    $return["headers"] = $headers;

    if (!isset($headers["HTTP_AUTHORIZATION"])) :
    // exit("not allowed");
    else :
        $token = $headers["HTTP_AUTHORIZATION"];
        $token = str_replace("Bearer ", "", $token);
        // ($headers["HTTP_AUTHORIZATION"])

        $allowed = (array) Helpers::getEnv(__DIR__ . "/../AccessFiles/_tokens.env");

        // print_r($allowed);
        $isallow = array_search($token, $allowed);
        // echo var_dump($isallow);
        if ($isallow === false)
            exit("not allowed");

        $jwt = Helpers::jwtTokenDecode($token);

        $company = (array) Helpers::getEnv(__DIR__ . "/../AccessFiles/{$jwt->jti->company}.env");

        $request = $request->withAttribute("company", $company);
    endif;

    $response = $next($request, $response);

    return $response
        ->withHeader('Access-Control-Allow-Origin', '*')
        ->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization, JWT')
        ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
});

$app->get("[/]", function (Request $request, Response $response, array $args) {
    $return = [];
    $return["success"] = true;
    $return["version"] = "1.3";

    $headers = $request->getHeaders();
    foreach ($headers as $name => $values)
        $headers[$name] = implode(", ", $values);

    $return["headers"] = $headers;
    $company = (object) $request->getAttribute("company");

    // $return["env"] = $company;

    return $response->withJson($return, 200);
});
$app->group("/services", function ($app) {
    include __DIR__ . "/../Routes/services/sicoob.php";
    include __DIR__ . "/../Routes/services/comunication.php";

    include __DIR__ . "/../Routes/services/companies.php";
    include __DIR__ . "/../Routes/services/accountant.php";
    include __DIR__ . "/../Routes/services/checkout.php";
    include __DIR__ . "/../Routes/services/invoices.php";

    include __DIR__ . "/../Routes/services/fast.php";
    include __DIR__ . "/../Routes/services/ncm.php";

    include __DIR__ . "/../Routes/services/cep.php";
    include __DIR__ . "/../Routes/services/cnpj.php";

    $app->post('/decript', function (Request $request, Response $response, array $args) {
        $data = $request->getParsedBody();

        $return = [];
        $return["success"] = true;
        $return["key"] = $data["key"];
        $return["text"] = Helpers::encript($data["key"]);

        if ($return["success"])
            return $response->withJson($return, 200);
        else
            return $response->withJson($return, 200);
    });

    $app->post('/tokenizer', function (Request $request, Response $response, array $args) {
        $data = $request->getParsedBody();

        $return = [];
        $return["success"] = true;
        // $return["company"] = strtolower($data["company_slug"]);

        $jti = ["company" => $data["company_slug"]];

        $return["token"] = Helpers::jwtToken("apps", $jti);

        if ($return["success"])
            return $response->withJson($return, 200);
        else
            return $response->withJson($return, 200);
    });
});
/*




    include __DIR__ . "/../Routes/services/autocomplete.php";


    // $app->any("/notification[/{emiter}", function (Request $request, Response $response, $args) {
    //     $return["success"] = false;

    //     $headers = $request->getHeaders();
    //     foreach ($headers as $name => $values)
    //         $headers[$name] = implode(", ", $values);

    //     $get = $_GET;
    //     $post = $_POST;
    //     $body = (array) $request->getParsedBody();

    //     $data = ["args" => $args, "get" => $get, "post" => $post, "headers" => $headers, "body" => $body];

    //     $db = new EDGVI10\DBWalker(["localhost", "edgvi10", "!Dev2Link)", "link"]);

    //     $emiter = $args["emiter"];

    //     $insert["table"] = "callback";
    //     $insert["data"]["emiter"] = $emiter;
    //     $insert["data"]["json"] = json_encode($data, true);

    //     $insert = $db->insert($insert, true);

    //     $return["insert"] = $insert;
    //     if (isset($_GET["code"])) :
    //         $return["success"] = true;
    //         $return["code"] = $_GET["code"];

    //         return $response->write(json_encode($return), 200);
    //     endif;
    //     return $response->withJson($return, 200);
    // });

    


$app->group("/{slug}", function ($app) {
    include __DIR__ . "/../Routes/apphub/catalog.php";
    include __DIR__ . "/../Routes/apphub/routes.php";
    include __DIR__ . "/../Routes/apphub/delivery.php";
    include __DIR__ . "/../Routes/apphub/orders.php";
    include __DIR__ . "/../Routes/apphub/users.php";
});
*/
// Run application

$app->run();
