<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$app->group("/catalog", function ($app) {
    $app->get("[/]", function (Request $request, Response $response, $args) {
        $get = (object) $_GET;
        $data = $request->getParsedBody();

        $company = (object) $request->getAttribute("company");

        $mysql_access = Functions::mysql_access($company);

        $db = new EDGVI10\DBWalker($mysql_access);

        $return["success"] = false;
        if (DEBUG) :
            $return["_get"] = $get;
            $return["_body"] = $data;
        endif;

        $select_products["table"] = "baselink.produtos AS prod";
        /* */
        $select_products["columns"] = [
            "prod.codigo_barras AS barcode",
            "prod.descricao AS name",
            "prod.substancia AS substancy",
            "prod.anvisa AS anvisa",
            "prod.anvisa AS anvisa",
            "marca.descricao AS brand",
            "prod.valor_venda AS unit_price",
            "prod.obs AS obs",
            "prod.data_cad AS date",
            "prod.hora AS time",
            "image.imagem AS thumbnail",
        ];
        /* */
        $select_products["where"]["param_excluir"] = 0;

        $select_products["joins"][] = ["RIGHT", "baselink.tab_marcas AS marca", "marca.codigo = prod.codigo_marca"];
        $select_products["joins"][] = ["LEFT", "baselink.tab_imagens AS image", "image.codigo = prod.codigo_barras"];

        $select_products["limit"] = 10;
        $select_products["order_by"] = "prod.descricao ASC";

        $select_products = (object) $db->select($select_products, true);

        $return["debug"] = $select_products;
        /* */
        $products = [];
        foreach ($select_products->data as $row) :
            $product = $row;

            $product->name = trim($row->name);
            if (isset($row->unit_price)) $product->unit_price = (float) $row->unit_price;
            if (isset($row->thumbnail)) $product->thumbnail = base64_encode($row->thumbnail);

            // $product->created_at = date("Y-m-d", strtotime($))

            $products[] = $product;
        endforeach;
        $return["products"] = $products;
        $return["data"] = $select_products->data;
        /* */
        return $response->withJson($return, 200);
    });
});
