<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$app->group("/accountant", function ($app) {
    $app->get("[/]", function (Request $request, Response $response, $args) {
        $get = (object) $_GET;
        $data = $request->getParsedBody();

        // $mysql_access = Functions::mysql_access("linkinfo");

        // $db = new EDGVI10\DBWalker($mysql_access);

        $return["success"] = false;
        if (DEBUG) :
            $return["_get"] = $get;
            $return["_body"] = $data;
        endif;

        if (!isset($get->cnpj)) :
            $return["error"][] = "Informe o CNPJ";
        elseif (!isset($get->type) || empty($get->type)) :
            $return["error"][] = "Informe o tipo de documento";
        else :

            $xml_params["table"] = strtoupper($get->type);
            $xml_params["cnpj"] = $get->cnpj;
            $xml_params["start"] = $get->start;
            $xml_params["end"] = $get->end;

            // $get->page = $get->page ?? 1;

            // if (isset($get->limit)) :
            //     $xml_params["limit"] = $get->limit;
            //     $xml_params["offset"] = ($get->page - 1) * $get->limit + 1;
            // endif;

            $linode = new EDGVI10\DBWalker(["api.linkinformaticarj.com.br", "public", "!Link2remote)", "accountants"]);
            $select_nf = Functions::getNF($linode, $xml_params, true);

            $documentos = [];
            $docs = [];
            foreach ($select_nf->data as $doc) :
                $docs[] = ["{$get->type}/{$doc->chave}.xml", $doc->xml];
            endforeach;

            $return["url"] = BASEURL;
            if (isset($get->download)) :
                $zip = new ZipArchive();
                $path = "storage/{$get->cnpj}-" . date("Ymdhis") . ".zip";
                if ($zip->open(PUBLIC_PATH . $path, ZipArchive::CREATE)) :
                    foreach ($docs as $doc) :
                        $zip->addFromString($doc[0], $doc[1]);
                    endforeach;

                    $zip->close();
                    chmod(PUBLIC_PATH . $path, 0755);
                    $return["message"] = "zip created in " . BASEURL . $path;
                else :
                    $return["message"] = "Zip don't created";
                endif;
            endif;

            $return["download_link"] = BASEURL . $path;

            $return["docs"] = count($docs);
        // $return["debug"] = $select_nf;
        endif;

        return $response->withJson($return, 200);
    });
});
