<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$app->group("/autocomplete", function ($app) {
    $app->get("/data[/{document}]", function (Request $request, Response $response, array $args) {
        $return["success"] = false;
        $get = $_GET;
        $body = (array) $request->getParsedBody();
        $data = array_merge($args, $get, $body);
        $data = (object) $data;

        if (DEBUG) :
            $return["_get"] = $get;
            $return["_body"] = $body;
            $return["_received"] = $data;
        endif;

        if (isset($data->document)) :
            $doc_len = strlen(Helpers::extractInt($data->document));

            $return["doc"] = $doc_len;

            if ($doc_len === 11) :
                $data->cpf = $data->document;
            elseif ($doc_len === 16) :
                $data->cnpj = $data->document;
            endif;
        endif;

        if (isset($data->cpf) && isset($data->birthdate)) :
            $api_key = "100520525iRyYSbztNK181486760";

            if (mb_strpos($data->birthdate, "/") === false) :
                $birthdate = explode("-", $data->birthdate);
                $data->birthdate = "{$birthdate[2]}/{$birthdate[1]}/{$birthdate[0]}";
            endif;

            $urlcpf = "https://ws.hubdodesenvolvedor.com.br/v2/cpf/?cpf={$data->cpf}&data={$data->birthdate}&token={$api_key}";

            $request = Helpers::call([
                "method" => "GET",
                "endpoint" => $urlcpf
            ], true);

            $return = $request["response"];
        elseif (isset($data->cnpj)) :
            $api_key = "100520525iRyYSbztNK181486760";

            $urlcnpj = "https://ws.hubdodesenvolvedor.com.br/v2/cnpj/?cnpj={$data->cnpj}&token={$api_key}";

            $request = Helpers::call([
                "method" => "GET",
                "endpoint" => $urlcnpj
            ], true);

            $return = $request["response"];
        endif;

        return $response->withJson($return, 200);
    });
});
