<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

function cadastraCheckout($payment_id)
{
}

function atualizaTabCheques()
{
}

class Helper
{
    public static function call(array $options, $debug = false)
    {
        $curl = curl_init();

        switch ($options["method"]):
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
                if (isset($options["data"]) && !empty($options["data"]))
                    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($options["data"]));
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
                if (isset($options["data"]) && !empty($options["data"]))
                    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($options["data"]));
                break;
            default:
                if (isset($options["data"]) && !empty($options["data"]))
                    $options["endpoint"] = sprintf("%s?%s", $options["endpoint"], http_build_query($options["data"]));
        endswitch;

        $headers = [];
        if (isset($options["headers"])) $headers = $options["headers"];
        $headers[] = "Content-Type: application/json";

        // OPTIONS:
        curl_setopt($curl, CURLOPT_URL, $options["endpoint"]);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_HEADER, false);

        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);

        // EXECUTE:
        $response = curl_exec($curl);
        curl_close($curl);

        $result["response"] = self::isJson($response) ? json_decode($response, 1) : $response;

        if ($debug) :
            $result["debug"]["curl"] = print_r($curl, true);
            $result["debug"]["options"] = print_r($options, true);

            return $result;
        endif;

        return (!empty($callback) && is_callable($callback)) ? $callback($result) : $result;
    }

    public static function isJson($string)
    {
        json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE);
    }

    public static function isAssoc(array $arr)
    {
        if (array() === $arr) return false;
        return array_keys($arr) !== range(0, count($arr) - 1);
    }
}

class MercadoPagoPayment
{
    function __construct(string $token)
    {
        $this->baseurl = "https://api.mercadopago.com/v1/";

        $this->headers = [
            "Authorization: Bearer {$token}",
            "Accept: application/json",
        ];
    }

    public function PaymentDetails(string $id, bool $debug = false)
    {
        $return["success"] = false;
        if (empty($id)) :
            $return["message"][] = "Informe o ID";
        else :
            $baseurl = $this->baseurl;
            $headers = $this->headers;

            $call = \Helper::call(
                [
                    "method" => "GET",
                    "endpoint" => "{$baseurl}/payments/{$id}",
                    "headers" => $headers,
                ],
                $debug
            );

            $request = (object) $call["response"];

            if ($request->error) :
                $return["message"] = $request->message;
            else :
                $response = (object)[];

                $response->id = $request->id;
                $response->status = $request->status;
                $response->status_detail = $request->status_detail;

                $response->authorization_code = $request->authorization_code;
                $response->captured = (bool) $request->captured;
                $response->notification_url = $request->notification_url;
                $response->operation_type = $request->operation_type;

                $response->card = (object) [
                    "token" => $request->card["id"],
                    "owner" => $request->card["cardholder"]["name"],
                    "owner_" . strtolower($request->card["cardholder"]["identification"]["type"]) => $request->card["cardholder"]["identification"]["number"],
                    // "number" => $request->card["first_six_digits"] . "******" . $request->card["last_four_digits"],
                    "issuer" => $request->payment_method_id,
                    "number" => "**** **** **** " . $request->card["last_four_digits"],
                    "expires" => str_pad($request->card["expiration_month"], 2, "0", STR_PAD_LEFT) . "/" . $request->card["expiration_year"],
                ];

                $response->payer = (object) [
                    "id" => $request->payer["id"],
                    "name" => $request->payer["first_name"] . " " . $request->payer["last_name"],
                    "email" => $request->payer["email"],
                    strtolower($request->payer["identification"]["type"]) => $request->payer["identification"]["number"],
                    "phone" => trim(implode("", $request->payer["phone"])),
                ];

                $response->order = (object) [
                    "description" => $request->description,
                    "payment_method_id" => $request->payment_method_id,
                    "payment_type_id" => $request->payment_type_id,
                    "statement_descriptor" => $request->statement_descriptor,

                    "amount" => $request->transaction_amount,
                    "installments" => $request->installments,

                    "shipping_amount" => $request->shipping_amount,
                    "taxes_amount" => $request->taxes_amount,

                    "total_paid" => $request->transaction_details["total_paid_amount"],
                ];

                $return["success"] = true;
                $return["data"] = $response;
            endif;
            if ($debug) $return["debug"] = $request;
        endif;

        return $return;
    }

    public function MakePayment(array $payload, bool $debug = false)
    {
        $return["success"] = false;

        $baseurl = $this->baseurl;
        $headers = $this->headers;

        $call = \Helper::call(
            [
                "method" => "POST",
                "endpoint" => "{$baseurl}/payments",
                "headers" => $headers,
                "data" => $payload,
            ],
            $debug
        );

        $request = (object) $call["response"];

        if ($request->status !== "approved") :
            $return["message"] = "Erro ao processar pagamento: " . $request->message;

            if ($request->status == "rejected") $return["message"] = "Pagamento recusado, verifique seus dados e limite tente novamente.";

            if ($request->status == "in_process") $return["message"] = "Não conseguimos retorno do seu banco. Seu pagamento está em análise.";

            $return["status_message"] = $request->status;
            $return["status_detail"] = $request->status_detail;
        else :
            $response = (object)[];

            $response->id = $request->id;
            $response->status = $request->status;
            $response->status_detail = $request->status_detail;

            $response->authorization_code = $request->authorization_code;
            $response->captured = (bool) $request->captured;
            $response->notification_url = $request->notification_url;
            $response->operation_type = $request->operation_type;

            $response->card = (object) [
                "token" => $request->card["id"],
                "owner" => $request->card["cardholder"]["name"],
                "owner_" . strtolower($request->card["cardholder"]["identification"]["type"]) => $request->card["cardholder"]["identification"]["number"],
                // "number" => $request->card["first_six_digits"] . "******" . $request->card["last_four_digits"],
                "issuer" => $request->payment_method_id,
                "number" => "**** **** **** " . $request->card["last_four_digits"],
                "expires" => str_pad($request->card["expiration_month"], 2, "0", STR_PAD_LEFT) . "/" . $request->card["expiration_year"],
            ];

            $response->payer = (object) [
                "id" => $request->payer["id"],
                "name" => $request->payer["first_name"] . " " . $request->payer["last_name"],
                "email" => $request->payer["email"],
                strtolower($request->payer["identification"]["type"]) => $request->payer["identification"]["number"],
                "phone" => trim(implode("", $request->payer["phone"])),
            ];

            $response->order = (object) [
                "description" => $request->description,
                "payment_method_id" => $request->payment_method_id,
                "payment_type_id" => $request->payment_type_id,
                "statement_descriptor" => $request->statement_descriptor,

                "amount" => $request->transaction_amount,
                "installments" => $request->installments,

                "shipping_amount" => $request->shipping_amount,
                "taxes_amount" => $request->taxes_amount,

                "total_paid" => $request->transaction_details["total_paid_amount"],
            ];

            $return["success"] = true;
            $return["data"] = $response;
        endif;
        if ($debug) $return["debug"] = $request;
        return $return;
    }

    public function Chargeback(string $id, array $options, bool $debug = false)
    {
        $return["success"] = false;

        return $return;
    }
}


$app->group("/checkout", function ($app) {
    $app->any("/notification/sicoob/{store_id}/{operation}", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        $headers = $request->getHeaders();
        foreach ($headers as $name => $values)
            $headers[$name] = implode(", ", $values);

        $get = $_GET;
        $post = $_POST;
        $body = (array) $request->getParsedBody();

        $data = ["args" => $args, "get" => $get, "post" => $post, "headers" => $headers, "body" => $body];

        $db = new EDGVI10\DBWalker(["localhost", "edgvi10", "!Dev2Link)", "link"]);

        if (isset($args["emiter"])) $emiter = $args["emiter"];
        if (isset($_GET["data_id"])) $payment_id = $_GET["data_id"];

        $insert["table"] = "checkout_callback";
        $insert["data"]["emiter"] = $emiter ?? "indefinido";
        $insert["data"]["payment_id"] = $payment_id ?? "indefinido";
        $insert["data"]["json"] = json_encode($data, true);

        $insert_sicoob = $db->insert([
            "table" => "checkout_sicoob",
            "data" => [
                "store_id" => $args["store_id"],
                "code" => $get["code"],
            ],
        ]);

        $insert = $db->insert($insert, true);
        $return = $insert;

        return $response->withJson($return, 200);
    });

    $app->any("/notification[/{emiter}[/store_id]]", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        $headers = $request->getHeaders();
        foreach ($headers as $name => $values)
            $headers[$name] = implode(", ", $values);

        $get = $_GET;
        $post = $_POST;
        $body = (array) $request->getParsedBody();

        $data = ["args" => $args, "get" => $get, "post" => $post, "headers" => $headers, "body" => $body];

        $db = new EDGVI10\DBWalker(["localhost", "edgvi10", "!Dev2Link)", "link"]);

        $emiter = $args["emiter"];
        $payment_id = $_GET["data_id"];

        $insert["table"] = "checkout_callback";
        $insert["data"]["emiter"] = $emiter;
        $insert["data"]["payment_id"] = $payment_id;
        $insert["data"]["json"] = json_encode($data, true);

        $insert = $db->insert($insert, true);
        // if (!empty($payment_id))
        if ($headers["HTTP_REFERER"] == "https://api.sisbr.com.br/") :
            $insert_sicoob = $db->insert(["table" => "checkout_sicoob", "data" => ["store_id" => "infolink", "code" => $get["code"]]]);

            return $response->withJson($get["code"], 200);
        endif;

        // $return = $insert;
        if (isset($_GET["code"])) :
            $return["success"] = true;
            $return["code"] = $_GET["code"];

            return $response->write(json_encode($return), 200);
        endif;
        return $response->withJson($return, 200);
    });


    $app->group("/mercadopago", function ($app) {
        $app->get("/{payment_id}", function (Request $request, Response $response, $args) {
            // $mp_token = "APP_USR-4315261641690764-011213-9ae38f06d52b536418716b2e45564806-89587893";
            $mp_token = "APP_USR-4079198112806961-050203-902261617301404b552afae296e74c59-89587893";
            $MercadoPago = new \MercadoPagoPayment($mp_token);

            $return["success"] = false;

            $res = (object) $MercadoPago->PaymentDetails($args["payment_id"], true);

            if (!$res->success) :
                $return["message"] = $res->message;
            else :
                $return["success"] = true;
                $return["data"] = $res->data;
            endif;

            return $response->withJson($return, 200);
        });

        $app->post("", function (Request $request, Response $response, $args) {
            // $mp_token = "APP_USR-4315261641690764-011213-9ae38f06d52b536418716b2e45564806-89587893";
            // $mp_token = "APP_USR-4315261641690764-042218-ff304a120d0917dec454b2e31d7021a2-89587893";
            $mp_token = "APP_USR-4079198112806961-050203-902261617301404b552afae296e74c59-89587893";
            $MercadoPago = new \MercadoPagoPayment($mp_token);

            $return["success"] = false;

            $data = (object) $request->getParsedBody();

            $payload = [
                "notification_url" => "https://api.linkinformaticarj.com.br/apps/services/checkout/notification/mercadopago/linkinfo",
                "token" => $data->token,
                "installments" => (int) $data->payment_installments,
                "transaction_amount" => (float) $data->payment_amount,
                "description" => $data->payment_description,
                "payment_method_id" => $data->payment_method,
                "issuer_id" => (int) $data->issuer_id,
                "payer" => [
                    "email" => $data->customer_email,
                    // "name" => $data->card_owner,
                    "identification" => [
                        "type" => $data->card_owner_type,
                        "number" => $data->card_owner_document,
                    ]
                ],
            ];

            $return["data"] = $payload;

            $res = (object) $MercadoPago->MakePayment($payload, true);
            $return["debug"] = $res;
            if (!$res->success) :
                $return["message"] = $res->message;
            else :
                $return["success"] = true;
                $return["data"] = $res->data;


                atualizaTabCheques("");
            endif;

            $db = new EDGVI10\DBWalker(["localhost", "edgvi10", "!Dev2Link)", "link"]);
            $insert = $db->insert(["table" => "log_pagamento", "data" => ["uuid" => "UUID()", "invoice_id" => $data->invoice_id, "cnpj" => $data->customer_cnpj, "data" => json_encode($payload)]]);
            $return["insert"] = $insert;

            return $response->withJson($return, 200);
        });
    });

    $app->group("/asaas", function ($app) {
        $app->post("/creditcard", function (Request $request, Response $response, $args) {
            $return = [];
            $return["success"] = false;

            $data = (object) $request->getParsedBody();
            $header = (object) $request->getHeaders();

            $payload = [];
            $payload["customer"] = $data->customer;

            $return["header"] = $header;
            $return["data"] = $data;
            $return["payload"] = $payload;

            //             $ch = curl_init();

            //             curl_setopt($ch, CURLOPT_URL, "https://www.asaas.com/api/v3/payments");
            //             curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            //             curl_setopt($ch, CURLOPT_HEADER, FALSE);

            //             curl_setopt($ch, CURLOPT_POST, TRUE);

            //             curl_setopt($ch, CURLOPT_POSTFIELDS, "{
            //   \"customer\": \"cus_0T1mdomVMi39\",
            //   \"billingType\": \"CREDIT_CARD\",
            //   \"dueDate\": \"2017-03-15\",
            //   \"value\": 100,
            //   \"description\": \"Pedido 056984\",
            //   \"externalReference\": \"056984\",
            //   \"creditCard\": {
            //     \"holderName\": \"marcelo h almeida\",
            //     \"number\": \"5162306219378829\",
            //     \"expiryMonth\": \"05\",
            //     \"expiryYear\": \"2021\",
            //     \"ccv\": \"318\"
            //   },
            //   \"creditCardHolderInfo\": {
            //     \"name\": \"Marcelo Henrique Almeida\",
            //     \"email\": \"marcelo.almeida@gmail.com\",
            //     \"cpfCnpj\": \"24971563792\",
            //     \"postalCode\": \"89223-005\",
            //     \"addressNumber\": \"277\",
            //     \"addressComplement\": null,
            //     \"phone\": \"4738010919\",
            //     \"mobilePhone\": \"47998781877\"
            //   },
            //   \"creditCardToken\": \"76496073-536f-4835-80db-c45d00f33695\"
            // }");

            //             curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            //                 "Content-Type: application/json",
            //                 "access_token: ".$header
            //             ));

            //             $res = curl_exec($ch);
            //             curl_close($ch);


            return $response->withJson($return, 200);
        });
    });
});
