<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$app->group("/cnpj", function ($app) {
    $app->get("/{cnpj}", function (Request $request, Response $response, $args) {
        $get = (object) $_GET;
        $data = $request->getParsedBody();

        function normalize($string)
        {
            $list = ["À" => "A", "Á" => "A", "Â" => "A", "Ã" => "A", "Ä" => "A", "Å" => "A", "Ç" => "C", "È" => "E", "É" => "E", "Ê" => "E", "Ë" => "E", "Ì" => "I", "Í" => "I", "Î" => "I", "Ï" => "I", "Ñ" => "N", "Ò" => "O", "Ó" => "O", "Ô" => "O", "Õ" => "O", "Ö" => "O", "Ø" => "O", "Ù" => "U", "Ú" => "U", "Û" => "U", "Ü" => "U", "Ý" => "Y", "à" => "a", "á" => "a", "â" => "a", "ã" => "a", "ä" => "a", "å" => "a", "æ" => "a", "ç" => "c", "è" => "e", "é" => "e", "ê" => "e", "ë" => "e", "ì" => "i", "í" => "i", "î" => "i", "ï" => "i", "ð" => "o", "ñ" => "n", "ò" => "o", "ó" => "o", "ô" => "o", "õ" => "o", "ö" => "o", "ø" => "o", "ù" => "u", "ú" => "u", "û" => "u", "ý" => "y", "ý" => "y", "þ" => "b", "ÿ" => "y", "Ŕ" => "R", "ŕ" => "r"];
            $string = strtr($string, $list);
            $string = str_replace("'", "", $string);
            $string = strtolower($string);

            return $string;
        }

        if (!$args["cnpj"]) {
            return $response->withStatus(400)->withJson(["message" => "O CNPJ não foi informado"]);
            exit;
        }

        $request_api = curl_init();
        $brasilapi_cnpj = "https://brasilapi.com.br/api/cnpj/v1/{$args["cnpj"]}";
        curl_setopt($request_api, CURLOPT_URL, $brasilapi_cnpj);
        curl_setopt($request_api, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($request_api, CURLOPT_SSL_VERIFYPEER, false);

        $response_api = curl_exec($request_api);
        curl_close($request_api);

        if (!$response_api) {
            header("HTTP/1.0 500 Internal Server Error");
            echo "Erro ao consultar o CNPJ";
            exit;
        }

        $return = json_decode($response_api);

        return $response->withJson($return, 200);
    });
});
