<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$app->group("/companies", function ($app) {
    $app->get("", function (Request $request, Response $response, array $args) {
        $return["success"] = false;
        $get = $_GET;
        $body = (array) $request->getParsedBody();

        $data = array_merge($args, $get, $body);

        $data = (object) $data;

        $mysql_access = Functions::mysql_access("linkinfo");

        $db = new EDGVI10\DBWalker($mysql_access);

        if (DEBUG) :
            $return["_get"] = $get;
            $return["_body"] = $body;
            $return["_received"] = $data;
        endif;

        $select_companies["table"] = "`orc_link`.`clientes`";
        $select_companies["columns"] = [
            "codigo_cliente AS id",
            "nome AS name",
            "fantasia AS fancyname",
            "cpf_cgc AS cnpj",
            "situacao AS status",

            "contato AS contact_name",
            "tel1 AS phone",
            "email AS email",

            "endereco AS address",
            "complemento AS address_complement",
            "numero AS address_number",
            "bairro AS address_neighborhood",
            "cidade AS address_city",
            "estado AS address_state",
            "cep AS address_zip",

            "liberacao.liberacao AS available",

            "data_cad AS created_at",
            "data_alt AS updated_at",
        ];
        $select_companies["where"]["raw"][] = "CHAR_LENGTH(cpf_cgc) > 11 AND cpf_cgc != ''";
        $select_companies["where"]["param_cinativo"] = 0;

        $select_companies["joins"][] = ["LEFT", "baselink.tab_liberacao AS liberacao", "liberacao.cnpj = cpf_cgc"];

        // exit(var_dump($data->cnpj));
        if (!empty($data->cnpj))
            $select_companies["where"]["param_cpf_cgc"] = $data->cnpj;

        $select_companies["group_by"] = "cpf_cgc";

        $select_companies = (object) $db->select($select_companies, true);

        if (!$select_companies->results) :
            $return["message"][] = "Empresa não encontrada";
            $return["debug"] = $select_companies;
        else :
            foreach ($select_companies->data as $company) :
                $company->contact_name = Helpers::capitalize($company->contact_name);
                $company->email = strtolower($company->email);

                $company->phone = ltrim(Helpers::extractInt($company->phone), 0);
                $company->address_zip = Helpers::extractInt($company->address_zip);

                $company->available = (bool) $company->available;

                $company->created_at = Helpers::dateTranslate($company->created_at);
                $company->updated_at = Helpers::dateTranslate($company->updated_at);

                $return["data"][] = $company;
            endforeach;
        endif;

        return $response->withJson($return, 200);
    });

    $app->get("/{cnpj}/release/{action:block|unblock}", function (Request $request, Response $response, array $args) {
        $return["success"] = false;
        $get = $_GET;
        $body = (array) $request->getParsedBody();

        $data = array_merge($args, $get, $body);

        $data = (object) $data;

        $mysql_access = Functions::mysql_access("linkinfo");

        $db = new EDGVI10\DBWalker($mysql_access);

        if (DEBUG) :
            $return["_get"] = $get;
            $return["_body"] = $body;
            $return["_received"] = $data;
        endif;

        $situation = null;
        if ($data->action == "block")
            $situation = 0;
        elseif ($data->action == "unblock")
            $situation = 1;

        $select_companies["table"] = "`orc_link`.`clientes`";
        $select_companies["columns"] = [
            "codigo_cliente AS id",
            "nome AS name",
            "fantasia AS fancyname",
            "cpf_cgc AS cnpj",
            "situacao AS status",

            "contato AS contact_name",
            "tel1 AS phone",
            "email AS email",

            "endereco AS address",
            "complemento AS address_complement",
            "numero AS address_number",
            "bairro AS address_neighborhood",
            "cidade AS address_city",
            "estado AS address_state",
            "cep AS address_zip",

            "liberacao.liberacao AS available",

            "data_cad AS created_at",
            "data_alt AS updated_at",
        ];
        $select_companies["where"]["param_cinativo"] = 0;

        $select_companies["joins"][] = ["LEFT", "baselink.tab_liberacao AS liberacao", "liberacao.cnpj = cpf_cgc"];

        // exit(var_dump($data->cnpj));
        if (!empty($data->cnpj))
            $select_companies["where"]["param_cpf_cgc"] = $data->cnpj;

        $select_companies = (object) $db->select($select_companies, true);

        if (!$select_companies->results) :
            $return["message"][] = "Empresa não encontrada";
            $return["debug"] = $select_companies;
        else :
            foreach ($select_companies->data as $company) :
                $company->contact_name = Helpers::capitalize($company->contact_name);
                $company->email = strtolower($company->email);

                $company->address_zip = Helpers::extractInt($company->address_zip);

                $company->available = (bool) $company->available;

                $company->created_at = Helpers::dateTranslate($company->created_at);
                $company->updated_at = Helpers::dateTranslate($company->updated_at);

                $select_available = [];
                $select_available["table"] = "baselink.tab_liberacao";
                $select_available["where"]["param_cnpj"] = $data->cnpj;

                $select_available = (object) $db->select($select_available, true);

                // $return["select"] = $select_available;

                if (!$select_available->results) :
                    $return["message"][] = "Criando Liberação";

                    $create_available["table"] = "baselink.tab_liberacao";
                    $create_available["data"]["cnpj"] = $company->cnpj;
                    $create_available["data"]["liberacao"] = $situation;

                    $create_available = $db->insert($create_available, true);
                    // $return["available"] = $create_available;
                    $return["success"] = $create_available["success"];
                else :
                    $return["message"][] = "Atualizando Liberação para {$situation}";
                    $update_available["table"] = "baselink.tab_liberacao";
                    $update_available["data"]["liberacao"] = $situation;
                    $update_available["where"]["param_cnpj"] = $company->cnpj;

                    $update_available = $db->update($update_available, true);
                    // $return["available"] = $update_available;
                    $return["success"] = $update_available["success"];
                endif;

                $company->available = (bool) $situation;

            // $return["data"][] = $company;
            endforeach;
        endif;

        return $response->withJson($return, 200);
    });
});
