<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$app->group("/invoices", function ($app) {
    $app->get("[/{cnpj}]", function (Request $request, Response $response, $args) {
        $return["success"] = false;
        $get = $_GET;
        $body = (array) $request->getParsedBody();

        $data = array_merge($args, $get, $body);

        $data = (object) $data;

        $mysql_access = Functions::mysql_access("linkinfo");

        $db = new EDGVI10\DBWalker($mysql_access);

        $return["success"] = false;
        if (DEBUG) :
            $return["_get"] = $get;
            $return["_body"] = $body;
            $return["_received"] = $data;
        endif;

        if (!isset($data->cnpj)) :
            $return["error"][] = "Informe o CNPJ";
        else :
            $select_invoices["table"] = "`baselink`.`tab_cheques` AS pagamento";
            $select_invoices["columns"] = [
                "pagamento.sequencial AS id",
                "clientes.codigo_cliente AS company_id",

                "clientes.nome AS company_name",
                "clientes.fantasia AS company_fancyname",
                "clientes.situacao AS company_status",
                "clientes.cpf_cgc AS company_cnpj",

                "clientes.contato AS contact_name",
                "clientes.tel1 AS contact_phone",
                "clientes.email AS contact_email",

                "pagamento.obs AS obs",
                "pagamento.vencimento AS payment_due",
                "pagamento.numero_documento AS payment_doc",
                "pagamento.situacao AS payment_status",

                "pagamento.valor_cheque AS payment_value",
                "pagamento.juros AS payment_ext",
                "pagamento.desconto AS payment_discount",
            ];
            $select_invoices["where"]["clientes.cpf_cgc"] = $data->cnpj;
            $select_invoices["joins"][] = ["LEFT", "orc_link.clientes AS clientes", "pagamento.cod_cliente = clientes.codigo_cliente"];

            $select_invoices["order_by"] = "pagamento.vencimento DESC";

            $select_invoices = (object) $db->select($select_invoices, true);


            $company_data = [
                "company_id", "company_name", "company_fancyname", "company_cnpj", "company_status",
                "contact_name", "contact_phone", "contact_email",
            ];

            // $return["data"] = $select_invoices;
            if (!$select_invoices->results) :
                $return["message"][] = "Empresa não encontrada";
            // $return["data"] = $select_invoices;
            else :
                $invoices = [];
                $client = [];
                $client["id"] = null;
                $client["name"] = null;
                $client["cnpj"] = null;
                $client["status"] = null;
                $client["invoice_pending"] = 0;

                foreach ($select_invoices->data as $invoice) :
                    switch ($invoice->payment_status):
                        case "A":
                            $invoice->payment_status = "Aberto";
                            break;
                        case "Q":
                            $invoice->payment_status = "Quitado";
                            break;
                        case "B":
                            $invoice->payment_status = "Baixado";
                            break;
                        case "C":
                            $invoice->payment_status = "Cancelado";
                            break;
                        default:
                            $invoice->payment_status = "Não definido";
                            break;
                    endswitch;

                    foreach ($company_data as $field) :
                        $key = str_replace("company_", "", $field);
                        $company[$key] = $invoice->$field;
                        unset($invoice->$field);
                    endforeach;

                    $invoice->payment_value = (float) $invoice->payment_value;
                    $invoice->payment_ext = (float) $invoice->payment_ext;
                    $invoice->payment_total = (float) $invoice->payment_value + $invoice->payment_ext - $invoice->payment_discount;

                    $invoice->payment_due = date("Y-m-d", strtotime($invoice->payment_due));

                    // $invoice->payment_total = $invoice->payment_value + $invoice->payment_ext;

                    if ($invoice->payment_status == "Aberto")
                        $company["invoice_pending"] = $invoice->payment_total + $company["invoice_pending"];

                    $invoices[] = $invoice;
                endforeach;

                $return["data"] = $company;
                $return["data"]["invoices"] = $invoices;
            endif;

            $return["success"] = true;

        endif;
        return $response->withJson($return, 200);
    });
});
