<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$app->group("/ncm/figurafiscal", function ($app) {
    $app->post("", function (Request $request, Response $response, array $args) {
        $return["success"] = false;
        $post = $request->getParsedBody();

        $id_parceiro = $post["id_parceiro"];
        $token = $post["token"];
        $cnpj = $post["cnpj"];
        $ncm = Helpers::extractInt($post["ncm"]);
        $atualizacao = $post["atualizacao"];

        if (!empty($atualizacao)) {
            $atualizacao = (implode("-", array_reverse(explode("-", $atualizacao))));
            $url = "https://figurafiscalws.com.br/v2.0/atualizacoes/{$id_parceiro}/{$cnpj}/{$token}?date=" . $atualizacao;
            $return["url_request"] = $url;

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            $result = curl_exec($curl);
            curl_close($curl);

            $return["result"] = json_decode($result);
        }

        if (!empty($ncm)) {
            $url = "https://figurafiscalws.com.br/v2.0/atualizacoes/{$id_parceiro}/{$cnpj}/{$token}?ncm=" . $ncm;
            $return["url_request"] = $url;

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            $result = curl_exec($curl);
            curl_close($curl);

            $return["result"] = json_decode($result);
        }

        return $response->withJson($return, 200);
    });
});
