<?php

use EDGVI10\Helpers;
use LinkApps\Functions;
use Slim\Handlers\Strategies\RequestResponse;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$app->group("/sicoob/{slug}", function ($app) {
    $app->get("", function (Request $request, Response $response, array $args) {
        $return["success"] = false;
        $get = $_GET;

        return $response->withJson($return, 200);
    });

    $app->post("/authorization", function (Request $request, Response $response, array $args) {
        $return["success"] = false;

        $data = (object) $request->getParsedBody();

        $params["method"] = "POST";
        $params["endpoint"] = "https://api.sisbr.com.br/auth/token";
        $params["headers"]["Authorization"] = "Basic " . $data->basic_token;
        $params["headers"]["Content-Type"] = "application/x-www-form-urlencoded";

        $params["data"]["grant_type"] = "authorization_code";
        $params["data"]["redirect_uri"] = "https://api.linkinformaticarj.com.br/apps/services/checkout/notification";
        $params["data"]["code"] = $data->code;
        $params["teste"] = http_build_query($params["data"]);

        // $return["call_params"] = $params;
        $call = (object) Helpers::call($params);

        $call_response = (object) $call->response;

        if (!isset($call_response->access_token)) :
            $return["message"] = $call;
        else :
            $return["success"] = true;
            $return["response"] = $call_response;
        endif;

        return $response->withJson($return, 200);
    });

    $app->post("/move/request", function (Request $request, Response $response, array $args) {
        $return["success"] = false;

        $data = (object) $request->getParsedBody();

        $params["method"] = "POST";
        $params["endpoint"] = "https://api.sisbr.com.br/cooperado/cobranca-bancaria/v1/boletos/solicitacoes/movimentacao";
        $params["headers"]["Authorization"] = "Bearer " . $data->access_token;
        $params["headers"]["Client_id"] = $data->client_id;
        $params["headers"]["Content-Type"] = "application/json";

        $params["data"]["numeroContrato"] = $data->contract;
        $params["data"]["tipoMovimento"] = $data->type;
        $params["data"]["dataInicial"] = $data->date_start;
        $params["data"]["dataFinal"] = $data->date_end;

        $return["call_params"] = $params;
        $call = (object) Helpers::call($params);
        $call_response = (object) $call->response;

        if (!isset($call_response->resultado)) :
            $return["message"] = $call;
        else :
            $return["success"] = true;
            $return["response"]["request_code"] = $call_response->resultado["codigoSolicitacao"];
        endif;

        return $response->withJson($return, 200);
    });

    $app->post("/move", function (Request $request, Response $response, array $args) {
        $return["success"] = false;

        $data = (object) $request->getParsedBody();

        $params["method"] = "GET";
        $params["endpoint"] = "https://api.sisbr.com.br/cooperado/cobranca-bancaria/v1/boletos/solicitacoes/movimentacao";
        $params["headers"]["Authorization"] = "Bearer " . $data->access_token;
        $params["headers"]["Client_id"] = $data->client_id;
        $params["headers"]["Content-Type"] = "application/json";

        $params["data"]["numeroContrato"] = $data->contract;
        $params["data"]["codigoSolicitacao"] = $data->request_code;

        // $return["call_params"] = $params;
        $call = (object) Helpers::call($params);
        $call_response = (object) $call->response;

        if (!isset($call_response->resultado)) :
            $return["message"] = $call;
        else :
            $return["success"] = true;
            $return["response"] = $call_response->resultado;
        endif;

        return $response->withJson($return, 200);
    });

    $app->post("/move/download", function (Request $request, Response $response, array $args) {
        $return["success"] = false;

        $data = (object) $request->getParsedBody();

        $params["method"] = "GET";
        $params["endpoint"] = "https://api.sisbr.com.br/cooperado/cobranca-bancaria/v1/boletos/movimentacao-download";
        $params["headers"]["Authorization"] = "Bearer " . $data->access_token;
        $params["headers"]["Client_id"] = $data->client_id;
        $params["headers"]["Content-Type"] = "application/json";

        $params["data"]["numeroContrato"] = $data->contract;
        $params["data"]["codigoSolicitacao"] = $data->request_code;
        $params["data"]["idArquivo"] = $data->file_id;

        $return["call_params"] = $params;
        $call = (object) Helpers::call($params);
        // $call = (object)[];
        // $call->response = [
        //     "resultado" => [
        //         "arquivo" => "UEsDBBQACAgIALIJelIAAAAAAAAAAAAAAAA0AAAATElRVUlfNDA0Ml8yNDU4NDRfMjAyMTAzMjYwMTEzMzY1NzQyNDgxXzE1NDA3XzAuanNvbpVS206DQBD9FcNzrbNbUOhbr0mTqtVUX4wPU3YlkwBTF+iL8d9drqUabxsCYc6Zs2cuT29ORlGM13ygRKc5O2Nnvbp7WDkDR2GOq5RC4j4qQYpzGJ2LYAswrh77a99NxpKSv9LTItGGZzFZrnbG0vV81+3CnOYGS402nrDCmBQqyxUtbUt5EVuSCEZS+AMn08VNBVR3X4iz42kMPuo0rO21uZ1JCV9NHjBm0zJHHgwDATBwQlYU8RSNwcwqXHmXge97lx6Ux9ICIVxwJQio7QPUDu238dF1aVEWqtCqNMgioSxDnnNYtG1skDUllOsNRtgDjv3CGRtTN1Nc+b6A1j4aeunPGIalzU8+NsZmc4Qh9m48dmtidQ2xqbFKd7LD/EfJNb0WdmK14m+b8y/yxugD2SbNjFZ0smlSfrdpU0xDvteh3mlV1iGg27ZJVNaJHWinIf2RhUltac+3+yWlNltTiXh+U/9cZyGfVF+Fr6v8k1BdW2+D3p8/AFBLBwhM1uAKegEAAHsDAABQSwECFAAUAAgICACyCXpSTNbgCnoBAAB7AwAANAAAAAAAAAAAAAAAAAAAAAAATElRVUlfNDA0Ml8yNDU4NDRfMjAyMTAzMjYwMTEzMzY1NzQyNDgxXzE1NDA3XzAuanNvblBLBQYAAAAAAQABAGIAAADcAQAAAAA=",
        //         "nomeArquivo" => "LIQUI_4042_245844_202103260113365742481_15407_0.zip",
        //         "diretorio" => "/mnt/CobrancaBancaria/TempMovimentacaoOpenBank",
        //         "extensao" => ".zip"
        //     ]
        // ];
        $call_response = (object) $call->response;

        if (!isset($call_response->resultado)) :
            $return["message"] = $call;
        else :

            $resultado = (object) $call_response->resultado;

            if (!$resultado->arquivo) :
                $return["message"] = "Arquivo não encontrado";
            else :
                $zip = new \ZipArchive();
                // $return["zip"] = $resultado->arquivo;

                // cria arquivo temporário
                $filename = tmpfile();
                fwrite($filename, base64_decode($resultado->arquivo));

                // lê informações do arquivo temporário
                $path = stream_get_meta_data($filename)['uri'];
                $zip->open($path);

                // Joca as info pra um array
                $files = [];
                for ($i = 0; $i < $zip->numFiles; $i++) {
                    $files[$zip->statIndex($i)["name"]] = json_decode($zip->getFromIndex($i));
                }

                $return["success"] = true;
                $return["response"]["base64"] = $call_response->resultado["arquivo"];
                $return["response"]["files"] = $files;
                fclose($filename);
            endif;
        endif;

        return $response->withJson($return, 200);
    });
});
