<?php

namespace Linkinfo;

use EDGVI10\DBWalker;

class Companies
{
    const query = [
        "table" => "`companies` AS `company`",
        "columns" => [
            "`company`.*",
            "(SELECT COUNT(*) FROM `users` WHERE `company_uuid` = `company`.`uuid` AND `deleted_at` IS NULL) AS `count_users`",
            "(SELECT COUNT(*) FROM `orders` WHERE `company_uuid` = `company`.`uuid`) AS `count_orders`",
            "(SELECT COUNT(*) FROM `customers` WHERE `company_uuid` = `company`.`uuid` AND `deleted_at` IS NULL) AS `count_customers`",
            "(SELECT COUNT(*) FROM `categories` WHERE `company_uuid` = `company`.`uuid` AND `deleted_at` IS NULL) AS `count_categories`",
            "(SELECT COUNT(*) FROM `products` WHERE `company_uuid` = `company`.`uuid` AND `deleted_at` IS NULL) AS `count_products`",
        ],
        "where" => [
            "null_`company`.`deleted_at`" => true,
        ],
        "order_by" => "`company`.`created_at`",
    ];

    public static function format($data)
    {
        $data->count_users = (int) $data->count_users;
        $data->count_orders = (int) $data->count_orders;
        $data->count_customers = (int) $data->count_customers;
        $data->count_categories = (int) $data->count_categories;
        $data->count_products = (int) $data->count_products;

        return (object) $data;
    }

    public static function list(array $options = [])
    {
        global $mysql_access;
        $db = new DBWalker($mysql_access);
        $return["success"] = false;

        $options = (object) $options;

        $select_sql = self::query;


        $select = (object) $db->select($select_sql);
        // $return["select"] = $select;
        if (!$select->success) :
            $return["message"] = $select->message;
        else :
            $data = [];
            foreach ($select->data as $row) :
                $row = self::format($row);

                $company_params = self::params(["company_uuid" => $row->uuid]);
                if ($company_params->success) $row->params = $company_params->data;

                $data[] = $row;
            endforeach;

            $return["data"] = $data;
            $return["success"] = true;
        endif;

        return (object) $return;
    }

    public static function store($data, array $options = [])
    {
        global $mysql_access;
        $db = new DBWalker($mysql_access);
        $return["success"] = false;

        $options = (object) $options;

        return (object) $return;
    }

    public static function params(array $options = [])
    {
        global $mysql_access;
        $db = new DBWalker($mysql_access);
        $return["success"] = false;

        $options = (object) $options;

        $select_params["table"] = "`companies_params` AS `param`";
        $select_params["columns"] = [
            "`param`.`key`",
            "`param`.`value`",
        ];
        $select_params["where"]["param_`param`.`active`"] = true;
        if (isset($options->company_uuid)) $select_params["where"]["param_`param`.`company_uuid`"] = $options->company_uuid;

        $select_params = (object) $db->select($select_params, true);
        // $company->param_sql = $select_params;
        $company_params = [];
        foreach ($select_params->data as $row) :
            if (isset($company_params[$row->key])) :
                $array = [];

                if (is_array($company_params[$row->key])) :
                    $array = $company_params[$row->key];
                //     $company_params[$row->key] = $company_params[$row->key];
                else :
                    $array[] = $company_params[$row->key];
                //     $company_params[$row->key][] = $company_params[$row->key];
                endif;

                $array[] = $row->value;

                $company_params[$row->key] = $array;
            else :
                $company_params[$row->key] = $row->value;
            endif;
        endforeach;
        $return["data"] = $company_params;
        $return["success"] = true;

        return (object) $return;
    }
}
