<?php

namespace Linkinfo;

use EDGVI10\DBWalker;
use EDGVI10\Helpers;

class Functions
{
    public static function encrypt($password)
    {
        $password = trim($password);
        $encrypted_password = null;
        for ($i = 0; $i < strlen($password); $i++) :
            $ascii = ord($password[$i]);
            $ascii_jumped = chr(intval($ascii) ^ (($i + 1) * 2));

            if ($ascii_jumped != "'") :
                $encrypted_password = $encrypted_password . $ascii_jumped;
            endif;
        endfor;

        return $encrypted_password;
    }

    public static function token($token)
    {
        $token = trim(str_replace("Bearer ", "", $token));

        $data["token"] = $token;

        $token = explode("-", Helpers::base64url_decode($token));
        $company_uuid = "{$token[0]}-{$token[1]}-{$token[2]}-{$token[3]}-{$token[4]}";
        $user_uuid = "{$token[7]}-{$token[8]}-{$token[9]}-{$token[10]}-{$token[11]}";

        $data["company_uuid"] = $company_uuid;
        $data["user_uuid"] = $user_uuid;

        return (object) $data;
    }

    public static function sendFCM($message, $fcm_token = null)
    {
        if (empty($fcm_token)) global $fcm_token;
        $return["success"] = false;

        $message = (object) $message;

        $data["to"] = $message->to;
        $data["data"]["notification"]["title"] = $message->title;
        $data["data"]["notification"]["body"] = $message->message;

        $request_options = [
            "method" => "POST",
            "endpoint" => "https://fcm.googleapis.com/fcm/send",
            "headers" => ["Authorization: key={$fcm_token}"],
            "data" => $data
        ];

        // $return["options"] = $request_options;

        $request = (object) Helpers::call($request_options);
        $response = (object) $request->response;

        if ($response->success == 0) :
            $return["message"] = "Não foi possível enviar a mensagem";
        else :
            $return["success"] = true;
            $return["message_id"] = $response->results[0]["message_id"];
        endif;

        return $return;
    }


    public static function getUserCode($access_token)
    {
        $token = Helpers::base64url_decode($access_token);
        $chunks = explode("-", $token);
        $uuid = "{$chunks[0]}-{$chunks[1]}-{$chunks[2]}-{$chunks[3]}-{$chunks[4]}";
        return $uuid;
    }

    public static function getCompanies($options = [])
    {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $options = (object) $options;

        $return = [];
        $return["success"] = false;

        $select_company["table"] = "`companies` AS `company`";
        $select_company["columns"] = [
            "`company`.`uuid`",
            "`company`.`active`",
            "`company`.`slug`",
            "`company`.`name`",
            "`company`.`fancyname`",
            "'' AS `url`",
            "`company`.`cnpj`",
            "`company`.`description`",
            "`company`.`logotipo`",
            "`company`.`banner`",
            "'' AS `params`",
        ];

        if (isset($options->company_slug) && !empty($options->company_slug)) $select_company["where"]["param_`company`.`slug`"] = $options->company_slug;

        $select_company = (object) $db->select($select_company, true);

        if ($select_company->success) :
            $companies = [];
            foreach ($select_company->data as $row) :
                $company = (object) $row;

                if (!$company->active) :
                    $company = "Empresa indisponível";
                else :
                    $company->url = "{$pkg->homepage}/{$company->slug}";

                    $select_params = [];
                    $select_params["table"] = "`companies_params` AS `param`";
                    $select_params["columns"] = [
                        "`param`.`key`",
                        "`param`.`value`",
                    ];
                    $select_params["where"]["param_`param`.`active`"] = true;
                    $select_params["where"]["param_`param`.`company_uuid`"] = $company->uuid;

                    $select_params = (object) $db->select($select_params, true);
                    // $company->param_sql = $select_params;
                    $company_params = [];
                    foreach ($select_params->data as $row) :
                        if (isset($company_params[$row->key])) :
                            $array = [];

                            if (is_array($company_params[$row->key])) :
                                $array = $company_params[$row->key];
                            //     $company_params[$row->key] = $company_params[$row->key];
                            else :
                                $array[] = $company_params[$row->key];
                            //     $company_params[$row->key][] = $company_params[$row->key];
                            endif;

                            $array[] = $row->value;

                            $company_params[$row->key] = $array;
                        else :
                            $company_params[$row->key] = $row->value;
                        endif;
                    endforeach;
                    $company->params = $company_params;

                endif;
                $companies[] = $company;
            endforeach;

            $return["success"] = true;
            $return["data"] = $companies;
        endif;

        return $return;
    }

    public static function getCategories(object $options = null, $company = null)
    {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $return = [];
        $return["success"] = false;

        $select_categories["table"] = "`categories` AS `category`";
        $select_categories["columns"] = [
            "`category`.`uuid`",
            "`category`.`active`",
            "`category`.`slug`",
            "`category`.`name`",
            "'' AS `url`",
            "`category`.`description`",
            "`category`.`thumbnail`",
            "`category`.`banner`",
            "`category`.`icon`",
            "`company`.`slug` AS `company_slug`",
            "`company`.`name` AS `company_name`",
            "`company`.`fancyname` AS `company_fancyname`",
            "'' AS `params`",
        ];
        $select_categories["joins"][] = ["LEFT", "`companies` AS `company`", "`company`.`uuid` = `category`.`company_uuid`"];


        if (isset($options->company_uuid) && !empty($options->company_uuid)) $select_categories["where"]["param_`category`.`company_uuid`"] = $options->company_uuid;

        $select_categories = (object) $db->select($select_categories, true);

        if (!$select_categories->success) :
            $return = $select_categories;
        else :
            $categories = [];
            foreach ($select_categories->data as $row) :
                $category = (object) $row;
                $category->url = "{$pkg->homepage}/{$category->company_slug}/{$category->slug}";

                $categories[] = $category;
            endforeach;

            $return["success"] = true;
            $return["data"] = $categories;
        endif;

        return $return;
    }
}
