<?php

namespace Linkinfo;

use EDGVI10\DBWalker;

class Orders
{
    const query = [
        "table" => "`orders` AS `order`",
        "order_by" => "`order`.`created_at`",
    ];

    public static function format($data)
    {
        return (object) $data;
    }

    public static function list(array $options = [])
    {
        global $mysql_access;
        $db = new DBWalker($mysql_access);
        $return["success"] = false;

        $options = (object) $options;

        $select_sql = self::query;


        $select = (object) $db->select($select_sql);
        // $return["select"] = $select;
        if (!$select->success) :
            $return["message"] = $select->message;
        else :
            $data = [];
            foreach ($select->data as $row) :
                $row = self::format($row);
                $data[] = $row;
            endforeach;

            $return["data"] = $data;
            $return["success"] = true;
        endif;

        return (object) $return;
    }

    public static function store($data, array $options = [])
    {
        global $mysql_access;
        $db = new DBWalker($mysql_access);
        $return["success"] = false;

        $options = (object) $options;

        return (object) $return;
    }
}
