<?php

namespace Linkinfo;

use EDGVI10\DBWalker;
use EDGVI10\Helpers;

class Products
{
    const query = [
        "table" => "`products` AS `product`",
        "where" => [
            "null_`product`.`deleted_at`" => true,
        ],
        "order_by" => "`product`.`created_at`",
    ];

    public static function format($data)
    {
        // $data->unit_count_type = ();
        $data->unit_count_type = ($data->unit_count_type === "1") ? "real" : "decimal";
        $data->unit_price_text = Helpers::pricemask($data->unit_price);
        $data->unit_price = (float) $data->unit_price;
        return (object) $data;
    }

    public static function list(array $options = [])
    {
        global $mysql_access;
        $db = new DBWalker($mysql_access);
        $return["success"] = false;

        $options = (object) $options;

        $select_sql = self::query;
        $select_sql["columns"] = [
            "`product`.*",
            "`category`.`name` AS `category_name`",
            "`category`.`slug` AS `category_slug`",
        ];
        $select_sql["joins"][] = ["LEFT", "`categories` AS `category`", "`category`.`id` = `product`.`category_id`"];

        if (isset($options->company_uuid) && !empty($options->company_uuid)) $select_sql["where"]["param_`product`.`company_uuid`"] = $options->company_uuid;

        $select = (object) $db->select($select_sql);
        // $return["select"] = $select;
        if (!$select->success) :
            $return["message"] = $select->message;
        else :
            $data = [];
            foreach ($select->data as $row) :
                $row = self::format($row);
                $data[] = $row;
            endforeach;

            $return["data"] = $data;
            $return["success"] = true;
        endif;

        return (object) $return;
    }

    public static function store($data, array $options = [])
    {
        global $mysql_access;
        $db = new DBWalker($mysql_access);
        $return["success"] = false;

        $options = (object) $options;

        return (object) $return;
    }
}
