<?php

error_reporting(E_ERROR);

require(__DIR__ . "/../vendor/autoload.php");

if (preg_match('/\.(?:png|jpg|jpeg|gif|zip)$/', $_SERVER["REQUEST_URI"])) {
    return false;
}

use \Slim\App as App;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

use \EDGVI10\Helpers;
use \EDGVI10\DBWalker as DB;

use Linkinfo\Functions;
use Linkinfo\Products;

Helpers::cors();

$env = Helpers::getEnv(__DIR__ . "/../.env");
$pkg = (object) json_decode(file_get_contents(__DIR__ . "/../composer.json"));


$debug = isset($env->debug) ? (bool) $env->debug : false;

setlocale(LC_TIME, 'pt_BR', 'pt_BR.iso-8859-1', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

$mysql_access = [
    $env->mysql_host,
    Functions::encrypt($env->mysql_user),
    Functions::encrypt($env->mysql_pass),
    $env->mysql_base,
];

$fcm_token = $env->fcm_token;

$config = ["settings" => ["displayErrorDetails" => true]];

$slim = new App($config);

$slim->get("[/]", function (Request $request, Response $response, array $args) {
    global $pkg;
    global $mysql_access;

    $return = [];
    $return["success"] = true;
    $return["version"] = $pkg->version;

    $db = new DB($mysql_access);
    $return["token"] = $db->UUID();

    return $response->withJson($return, 200);
});

$slim->post("/login", function (Request $request, Response $response, array $args) {
    global $pkg;
    global $mysql_access;

    $db = new DB($mysql_access);

    $data = (object) $request->getParsedBody();

    $return = [];
    $return["success"] = false;

    $select_user["table"] = "`users` AS `user`";
    $select_user["columns"] = [
        "'' AS `token`",
        "`user`.`uuid`",
        "`user`.`company_uuid`",
        "`company`.`active` AS `company_active`",
        "`company`.`name` AS `company_name`",
        "`user`.`name`",
        "`user`.`phone`",
        "`user`.`email`",
        "`user`.`active`",
        "`role`.`name` AS `role`",
        "`role`.`permissions` AS `permissions`",
    ];
    $select_user["joins"][] = ["LEFT", "`users_roles` AS `role`", "`role`.`id` = `user`.`role_id`"];
    $select_user["joins"][] = ["LEFT", "`companies` AS `company`", "`company`.`uuid` = `user`.`company_uuid`"];

    $select_user["where"]["param_`user`.`username`"] = $data->username;
    $select_user["where"]["param_`user`.`password`"] = md5($data->password);

    $select_user = (object) $db->select($select_user, true);

    if ($select_user->success) :
        if (count($select_user->data) !== 1) :
            $return["message"] = "Combinação usuário e senha inválida";
        else :
            $user = (object) $select_user->data[0];

            if (!$user->active) :
                $return["message"] = "Usuário bloqueado";
            else :
                $user->company_active = (bool) $user->company_active;

                if (!$user->company_active) :
                    $return["message"] = "Empresa bloqueada";
                else :
                    $return["token"] = Helpers::base64url_encode("{$user->company_uuid}-" . date("Ymd-His"));

                    unset($user->uuid, $user->token, $user->active, $user->company_active);

                    $return["success"] = $select_user->success;
                // $return["user"] = $user;
                endif;
            endif;
        endif;
    endif;

    return $response->withJson($return, 200);
});

$slim->post("/encrypt", function (Request $request, Response $response, array $args) {
    global $pkg;

    $data = (object) $request->getParsedBody();

    $return = [];
    $return["success"] = true;
    $return["version"] = $pkg->version;

    $return["return"] = Functions::encrypt($data->value);

    return $response->withJson($return, 200);
});

$slim->get("/companies", function (Request $request, Response $response, array $args) {
    global $pkg;
    global $mysql_access;

    $db = new DB($mysql_access);
    $return = [];
    $return["success"] = false;

    $select = [];
    $select["table"] = "`companies` AS `company`";
    $select["columns"] = [
        "`company`.`slug`",
        "`company`.`name`",
        "`company`.`fancyname`",
        "`company`.`cnpj`",
        "`company`.`logotipo`",
        "`company`.`banner`",
        "`company`.`description`",
    ];
    $select["where"]["param_`company`.`active`"] = true;

    $select = (object) $db->select($select, true);
    if ($select->success) :
        $return["companies"] = $select->data;
        $return["success"] = $select->success;
    endif;

    return $response->withJson($return, 200);
});

include_once(__DIR__ . "/../Routes/api/api.php");

$slim->group("/company/{company_slug}", function ($slim) {
    $slim->get("/profile", function (Request $request, Response $response, array $args) {

        $return = [];
        $return["success"] = false;

        $options = (object) [];
        $options->company_slug = $args["company_slug"];

        $companies = (object) Functions::getCompanies($options);
        if (!$companies->success) :
            $return = $companies;
        else :

            if (count($companies->data) === 0) :
                $return["message"] = "Nenhuma empresa encontrada";
            else :
                $company = $companies->data[0];
                if (!$company->active) :
                    $return["message"] = "Empresa bloqueada";
                else :

                    $return["company"] = $company;

                    $return["success"] = true;
                endif;
            endif;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->get("", function (Request $request, Response $response, array $args) {
        global $pkg;
        global $mysql_access;

        $db = new DB($mysql_access);

        $return = [];
        $return["success"] = false;

        $options = (object) [];
        $options->company_slug = $args["company_slug"];

        $companies = (object) Functions::getCompanies($options);
        if (!$companies->success) :
            $return = $companies;
        else :

            if (count($companies->data) === 0) :
                $return["message"] = "Nenhuma empresa encontrada";
            else :
                $company = $companies->data[0];
                if (!$company->active) :
                    $return["message"] = "Empresa bloqueada";
                else :
                    $categories_options = (object) [];
                    $categories_options->company_uuid = $company->uuid;

                    $payments = [];

                    $select_payments = [];
                    $select_payments["table"] = "`companies_payments` AS `company_payment`";
                    $select_payments["columns"] = [
                        "`company_payment`.`id`",
                        "`payment`.`group`",
                        "`payment`.`label`",
                        // "`payment`.`type`",
                        "`payment`.`icon`",
                        "`company_payment`.`created_at`",
                        "`company_payment`.`updated_at`",
                    ];
                    $select_payments["joins"][] = ["LEFT", "`opt_payment` AS `payment`", "`payment`.`id` = `company_payment`.`payment_id`"];
                    $select_payments["where"]["param_`company_payment`.`company_uuid`"] = $company->uuid;
                    $select_payments["where"]["param_`company_payment`.`active`"] = 1;
                    $select_payments["order_by"] = ["sort_order", "orderasc_group", "orderasc_type"];

                    $select_payments = (object) $db->select($select_payments);
                    foreach ($select_payments->data as $payment) :
                        $payment_grp = $payment->group;
                        $payments[] = $payment;
                    endforeach;

                    $company->payments = $payments;

                    $categories = (object) Functions::getCategories($categories_options);

                    $products_options = [];
                    $products_options["company_uuid"] = $company->uuid;
                    $products = (object) Products::list($products_options);

                    $company->categories = $categories->data;
                    $company->products = $products->data;

                    $return["company"] = $company;
                    $return["success"] = true;
                endif;
            endif;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->post("/customers/login", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $select_customer["table"] = "`customers` AS `customer`";
        $select_customer["columns"] = [
            "'' AS `token`",
            "`customer`.`uuid`",
            "`customer`.`company_uuid`",
            "`company`.`active` AS `company_active`",
            "`company`.`name` AS `company_name`",
            "`customer`.`name`",
            "`customer`.`phone`",
            "`customer`.`email`",
            "'' AS `address_list`",
            "`customer`.`active`",
        ];
        $select_customer["joins"][] = ["LEFT", "`companies` AS `company`", "`company`.`uuid` = `customer`.`company_uuid`"];

        $select_customer["where"]["param_`company`.`slug`"] = $args["company_slug"];
        if (filter_var($data->username, FILTER_VALIDATE_EMAIL)) :
            $return["login_type"] = "email";
            $select_customer["where"]["param_`customer`.`email`"] = $data->username;
        elseif (ctype_digit($data->username)) :
            $return["login_type"] = "phone";
            $select_customer["where"]["raw"][] = "`customer`.`phone` LIKE '%$data->username'";
        else :
            $return["message"] = "Informe um e-mail ou telefone válido";
            return $response->withJson($return, 200);
        endif;
        $select_customer["where"]["param_`customer`.`password`"] = md5($data->password);

        $select_customer = (object) $db->select($select_customer, true);

        $return["sql"] = $select_customer;

        if ($select_customer->success) :
            if (count($select_customer->data) !== 1) :
                $return["message"] = "Combinação usuário e senha inválida";
            else :
                $customer = (object) $select_customer->data[0];

                if (!$customer->active) :
                    $return["message"] = "Usuário bloqueado";
                else :
                    $customer->company_active = (bool) $customer->company_active;

                    if (!$customer->company_active) :
                        $return["message"] = "Empresa bloqueada";
                    else :
                        $date = dechex(date("Ymd")) . "-" . dechex(date("His"));
                        $return["token"] = Helpers::base64url_encode("{$customer->company_uuid}-{$date}-{$customer->uuid}");

                        $select_locations = [];
                        $select_locations["table"] = "`customers_locations` AS `location`";
                        $select_locations["columns"] = [
                            "`location`.`main`",
                            "`location`.`label`",
                            "'' AS `icon`",
                            "`location`.`type`",
                            "`location`.`address`",
                            "`location`.`complement`",
                            "`location`.`reference`",
                            "`location`.`zipcode`",
                            "`location`.`latlng`",
                        ];
                        $select_locations["where"]["param_`location`.`customer_uuid`"] = $customer->uuid;
                        $select_locations["where"]["param_`location`.`active`"] = 1;

                        $select_locations = (object) $db->select($select_locations, true);
                        $locations = [];
                        foreach ($select_locations->data as $location) :
                            $location->main = (bool) $location->main;

                            switch ($location->type):
                                case 1:
                                    $location->icon = "fad fa-marker";
                                    break;
                                case 2:
                                    $location->icon = "fad fa-home";
                                    break;
                                case 3:
                                    $location->icon = "fad fa-building";
                                    break;
                                default:
                                    $location->icon = "fad fa-marker";
                                    break;
                            endswitch;

                            unset($location->type);
                            $locations[] = $location;
                        endforeach;

                        $customer->address_list = $locations;

                        unset($customer->uuid, $customer->token, $customer->active, $customer->company_active);

                        $return["success"] = $select_customer->success;
                        $return["customer"] = $customer;
                    endif;
                endif;
            endif;
        endif;

        return $response->withJson($return, 200);
    });
});

$slim->group("/dashboard", function ($slim) {
    $slim->post("/login", function (Request $request, Response $response, array $args) {
        global $pkg;
        global $mysql_access;

        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $select_user["table"] = "`users` AS `user`";
        $select_user["columns"] = [
            "'' AS `token`",
            "`user`.`uuid`",
            "`company`.`active` AS `company_active`",
            "`company`.`name` AS `company_name`",
            "`user`.`name`",
            "`user`.`phone`",
            "`user`.`email`",
            "`user`.`active`",
            "`role`.`name` AS `role`",
            "`role`.`permissions` AS `permissions`",
        ];
        $select_user["joins"][] = ["LEFT", "`users_roles` AS `role`", "`role`.`id` = `user`.`role_id`"];
        $select_user["joins"][] = ["LEFT", "`companies` AS `company`", "`company`.`uuid` = `user`.`company_uuid`"];

        $select_user["where"]["param_`user`.`username`"] = $data->username;
        $select_user["where"]["param_`user`.`password`"] = md5($data->password);

        $select_user = (object) $db->select($select_user, true);

        if ($select_user->success) :
            if (count($select_user->data) !== 1) :
                $return["message"] = "Combinação usuário e senha inválida";
            else :
                $user = (object) $select_user->data[0];

                if (!$user->active) :
                    $return["message"] = "Usuário bloqueado";
                else :
                    $user->company_active = (bool) $user->company_active;

                    if (!$user->company_active) :
                        $return["message"] = "Empresa bloqueada";
                    else :
                        $return["token"] = Helpers::base64url_encode("{$user->uuid}-" . date("Ymd-His"));

                        unset($user->uuid, $user->token, $user->active, $user->company_active);

                        $return["success"] = $select_user->success;
                        $return["user"] = $user;
                    endif;
                endif;
            endif;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->group("/{access_token}", function ($slim) {
        $slim->get("", function (Request $request, Response $response, array $args) {
            global $pkg;
            global $mysql_access;

            $return = [];
            $return["success"] = true;
            $return["version"] = $pkg->version;

            $db = new DB($mysql_access);
            $return["token"] = $db->UUID();

            return $response->withJson($return, 200);
        });

        $slim->get("/companies[/{company_uuid}]", function (Request $request, Response $response, array $args) {
            $return = [];
            $return["success"] = false;

            $headers = $request->getHeaders();

            $options = (object) [];
            if (isset($args["company_uuid"])) $options->company_slug = $args["company_uuid"];

            $companies = (object) Functions::getCompanies($options);
            if (!$companies->success) :
                $return = $companies;
            else :
                $return["companies"] = [];
                foreach ($companies->data as $company) :
                    if ($company->active) :

                        $return["companies"][] = $company;
                    endif;
                endforeach;
                $return["success"] = true;
            endif;

            return $response->withJson($return, 200);
        });

        $slim->post("/companies", function (Request $request, Response $response, array $args) {
            global $pkg;
            global $mysql_access;

            $return = [];
            $return["success"] = false;

            $db = new DB($mysql_access);


            $headers = $request->getHeaders();

            $data = $request->getParsedBody();

            $company = (object) [];
            $company->uuid = $db->UUID();
            $company->name = (empty($data->company_name)) ? $data->company_name : $data->company_fancyname;
            $company->fancyname = (empty($data->company_fancyname)) ? $data->company_fancyname : $data->company_name;

            $company->slug = (empty($data->company_slug)) ? $data->company_slug : Helpers::slugfy($data->company_name);

            $insert_companies["table"] = "`companies`";
            $insert_companies["data"] = $company;

            $options = (object) [];

            $return["company"] = $insert_companies;

            return $response->withJson($return, 200);
        });

        $slim->get("/products[/{company_uuid}[/{product_uuid}]]", function (Request $request, Response $response, array $args) {
            global $pkg;
            global $mysql_access;

            $return = [];
            $return["success"] = false;

            $db = new DB($mysql_access);

            $headers = $request->getHeaders();
            $data = $request->getParsedBody();

            $select_products["table"] = "`products` AS `product`";

            $select_products["columns"] = [
                "`product`.`uuid`",
                "`product`.`active`",

                "`company`.`uuid` AS `company_uuid`",
                "`company`.`fancyname` AS `company_fancyname`",

                "`category`.`uuid` AS `category_uuid`",
                "`category`.`name` AS `category_name`",

                "`product`.`ref`",
                "`product`.`code`",
                "`product`.`name`",
                "`product`.`description`",

                "`product`.`thumbnail`",
                "`product`.`banner`",

                "`product`.`unit_price`",
                "`product`.`unit_count`",
                "`product`.`unit_count_type`",

                "`product`.`created_at`",
                "`product`.`updated_at`",
            ];

            $select_products["joins"][] = ["LEFT", "`companies` AS `company`", "`company`.`uuid` = `product`.`company_uuid`"];
            $select_products["joins"][] = ["LEFT", "`categories` AS `category`", "FIND_IN_SET(`category`.`id`, `product`.`category_id`)"];

            if (isset($args["product_uuid"]) && !empty($args["product_uuid"])) $select_products["where"]["param_`product`.`company_uuid`"] = $args["company_uuid"];
            if (isset($args["product_uuid"]) && !empty($args["product_uuid"])) $select_products["where"]["param_`product`.`uuid`"] = $args["product_uuid"];

            $select_products = (object) $db->select($select_products);

            if ($select_products->success) :
                $products = [];
                foreach ($select_products->data as $row) :
                    $product = $row;
                    $product->unit_price = (float) $product->unit_price;
                    $product->unit_count_type = ($product->unit_count_type === "1") ? "real" : "decimal";

                    $products[] = $product;
                endforeach;

                $return["products"] = $products;
            endif;

            return $response->withJson($return, 200);
        });
    });
});

$slim->group("/notify", function ($slim) {
    $slim->post("/{type}", function (Request $request, Response $response, $args) {
        $return = [];
        $return["success"] = false;

        $data = (object) $request->getParsedBody();

        if (empty($data->token)) :
            $message["message"] = "Token é obrigatório";
        else :
            $message["to"] = $data->token;
            $message["title"] = "Bem-vindo";
            $message["message"] = "Agora você poderá receber notificações";

            $sendFCM = (object) Functions::sendFCM($message);
            $return["fcm"] = $sendFCM;

            if ($sendFCM->success) :
                if ($args["type"] === "customer") :
                    $register_customer_fcm["table"] = "customers_fcm_tokens";
                    $register_customer_fcm["data"]["customer_uuid"] = $data->customer_uuid;
                    $register_customer_fcm["data"]["device"] = $data->device;
                    $register_customer_fcm["data"]["fcm_token"] = $data->fcm_token;

                    global $mysql_access;
                    $db = new DB($mysql_access);

                    $insert = (object) $db->insert($register_customer_fcm, true);
                    if ($insert->success) :
                        $return["success"] = $insert->success;
                        $return["response"]["message"] = "Dispositivo cadastrado com sucesso";
                    endif;
                elseif ($args["type"] === "company") :
                    $return["message"] = "Comming soon";
                endif;
            endif;

        endif;

        return $response->withJson($return, 200);
    });

    $slim->put("/{type}", function (Request $request, Response $response, $args) {
        $return = [];
        $return["success"] = false;

        $data = $request->getParsedBody();

        return $response->withJson($return, 200);
    });
});

// Run application
$slim->run();
