<?php

error_reporting(E_ERROR);

require(__DIR__ . "/../vendor/autoload.php");

if (preg_match('/\.(?:png|jpg|jpeg|gif|zip)$/', $_SERVER["REQUEST_URI"])) {
    return false;
}

use \EDGVI10\Helpers;
use \EDGVI10\DBWalker as DB;
use EDGVI10\DBWalker;
use Linkinfo\Functions;
use Linkinfo\Products;
use \Slim\App as App;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

Helpers::cors();

$env = Helpers::getEnv(__DIR__ . "/../.env");
$pkg = (object) json_decode(file_get_contents(__DIR__ . "/../composer.json"));


$debug = isset($env->debug) ? (bool) $env->debug : false;


setlocale(LC_TIME, 'pt_BR', 'pt_BR.iso-8859-1', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

$mysql_access = [
    $env->mysql_host,
    Functions::encrypt($env->mysql_user),
    Functions::encrypt($env->mysql_pass),
    $env->mysql_base,
];

$fcm_token = $env->fcm_token;

$config = ["settings" => ["displayErrorDetails" => true]];

$slim = new App($config);

$slim->get("[/]", function (Request $request, Response $response, array $args) {
    global $pkg;
    global $mysql_access;

    $return = [];
    $return["success"] = true;
    $return["version"] = $pkg->version;

    $db = new DB($mysql_access);
    $return["token"] = $db->UUID();

    return $response->withJson($return, 200);
});

$slim->group("/v1", function ($slim) {
    include_once(__DIR__ . "/../Routes/api/v1/companies.php");
    include_once(__DIR__ . "/../Routes/api/v1/customers.php");
    include_once(__DIR__ . "/../Routes/api/v1/products.php");

    $slim->post("/teste", function (Request $request, Response $response, array $args) {
        global $pkg;

        $return = [];
        $return["success"] = true;
        $return["version"] = $pkg->version;

        return $response->withJson($return, 200);
    });
});
/*
$slim->group("/services", function ($slim) {

    $slim->post("/file-base64", function (Request $request, Response $response, array $args) {
        ini_set('upload_max_filesize', '60M');
        ini_set('post_max_size', '72M');
        ini_set('max_input_time', 300);
        ini_set('max_execution_time', 300);

        $return["success"] = true;

        // $return["file"] = $_FILES;
        $files = [];
        $files_raw = $_FILES["files"];
        for ($i = 0; $i < count($files_raw["name"]); $i++) :

            // move_uploaded_file($files_raw["tmp_name"][$i], $files_raw["name"][$i]);

            $file = (object) [];
            $file->name = $files_raw["name"][$i];
            $file->type = mime_content_type($files_raw["tmp_name"][$i]);
            $file->size_kb = round($files_raw["size"][$i] / 8 / 64, 2);
            $binary = base64_encode(file_get_contents($files_raw["name"][$i]));
            $file->base64 = "data:{$file->type};base64,{$binary}";

            $files[] = $file;
        endfor;

        $return["files"] = $files;
        // $return["base64"][] = base64_encode($files);

        return $response->withJson($return, 200);
    });
});
*/
// Run application
$slim->run();
