<?php

use EDGVI10\DBWalker;
use EDGVI10\Helpers;
use Linkinfo\Functions;
use Slim\Http\Request;
use Slim\Http\Response;

$slim->group("/api", function ($slim) {
    $slim->post("/token", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $select_user["table"] = "`users` AS `user`";
        $select_user["columns"] = [
            "'' AS `token`",
            "`user`.`uuid`",
            "`user`.`company_uuid`",
            "`company`.`active` AS `company_active`",
            "`company`.`name` AS `company_name`",
            "`user`.`name`",
            "`user`.`phone`",
            "`user`.`email`",
            "`user`.`active`",
            "`role`.`name` AS `role`",
            "`role`.`permissions` AS `permissions`",
        ];
        $select_user["joins"][] = ["LEFT", "`users_roles` AS `role`", "`role`.`id` = `user`.`role_id`"];
        $select_user["joins"][] = ["LEFT", "`companies` AS `company`", "`company`.`uuid` = `user`.`company_uuid`"];

        $select_user["where"]["param_`user`.`username`"] = $data->username;
        $select_user["where"]["param_`user`.`password`"] = md5($data->password);

        $select_user = (object) $db->select($select_user, true);

        if ($select_user->success) :
            if (count($select_user->data) !== 1) :
                $return["message"] = "Combinação usuário e senha inválida";
            else :
                $user = (object) $select_user->data[0];

                if (!$user->active) :
                    $return["message"] = "Usuário bloqueado";
                else :
                    $user->company_active = (bool) $user->company_active;

                    if (!$user->company_active) :
                        $return["message"] = "Empresa bloqueada";
                    else :
                        $date = dechex(date("Ymd")) . "-" . dechex(date("His"));
                        $return["token"] = Helpers::base64url_encode("{$user->company_uuid}-{$date}-{$user->uuid}");

                        unset($user->uuid, $user->token, $user->active, $user->company_active);

                        $return["success"] = $select_user->success;
                    // $return["user"] = $user;
                    endif;
                endif;
            endif;
        endif;

        return $response->withJson($return, 200);
    });

    include_once(__DIR__ . "/payments.php");
    include_once(__DIR__ . "/categories.php");
    include_once(__DIR__ . "/products.php");
    include_once(__DIR__ . "/orders.php");
});
