<?php

use EDGVI10\DBWalker;
use Linkinfo\Functions;
use Slim\Http\Request;
use Slim\Http\Response;

$slim->group("/categories", function ($slim) {
    $slim->post("", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $return["headers"] = $headers;

        return $response->withJson($return, 200);
    });

    $slim->get("[/{category_uuid}]", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $token = Functions::token(trim(str_replace("Bearer ", "", $headers->HTTP_AUTHORIZATION[0])));

        $params = (object) $_GET;
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $select_categories["table"] = "`categories` AS `category`";

        $select_categories["columns"] = [
            "`category`.`uuid`",
            "`category`.`order`",
            "`category`.`slug`",
            "`category`.`name`",
            "`category`.`description`",
            "`category`.`thumbnail`",
            "`category`.`banner`",
            "`category`.`icon`",
            "`category`.`active`",
            "`category`.`created_at`",
            "`category`.`updated_at`",
            "`category`.`deleted_at`",
        ];

        $select_categories["where"]["param_`category`.`company_uuid`"] = $token->company_uuid;
        if (isset($args["category_uuid"])) $select_categories["where"]["param_`category`.`uuid`"] = $args["category_uuid"];

        $select_categories = (object) $db->select($select_categories, true);
        // $return["select_categories"] = $select_categories;

        $categories = [];
        foreach ($select_categories->data as $category) :

            $categories[] = $category;
        endforeach;

        $return["categories"] = $categories;
        $return["success"] = true;

        return $response->withJson($return, 200);
    });
});
