<?php

use EDGVI10\DBWalker;
use Linkinfo\Functions;
use Slim\Http\Request;
use Slim\Http\Response;

$slim->group("/companies", function ($slim) {
    $slim->post("", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $token = Functions::token($headers->HTTP_AUTHORIZATION[0]);

        $headers = (object) $request->getHeaders();

        $params = (object) $_GET;
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $company = (object) [];
        $company->uuid = $db->UUID();
        $company->cnpj = $data->cnpj;
        $company->name = (isset($data->name) && !empty($data->name)) ? $data->name : $data->fancyname;
        $company->fancyname = (isset($data->fancyname) && !empty($data->fancyname)) ? $data->fancyname : $data->name;

        $select = [];
        $select["table"] = "`companies`";
        $select["where"]["param_`cnpj`"] = $company->cnpj;

        $select = (object) $db->select($select, true);

        if (count($select->data) > 0) :
            $return["message"] = "CNPJ já cadastrado";
        else :

        endif;

        return $response->withJson($return, 200);
    });

    $slim->get("[/{company_uuid}]", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $token = Functions::token($headers->HTTP_AUTHORIZATION[0]);

        $params = (object) $_GET;
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $select["table"] = "`companies` AS `company`";

        $select["columns"] = [
            "`company`.`id`",
            "`company`.`uuid`",
            "`company`.`ref`",
            "`company`.`code`",
            "`company`.`name`",
            "`company`.`description`",

            "`company`.`thumbnail`",
            "`company`.`banner`",

            "`company`.`unit_price`",
            "`company`.`unit_count`",
            "`company`.`unit_count_type`",

            "`category`.`uuid` AS `category_uuid`",
            "`category`.`name` AS `category_name`",

            "'' AS `options`",

            "`company`.`active`",
            "`company`.`created_at`",
            "`company`.`updated_at`",
            "`company`.`deleted_at`",
        ];

        $select["joins"][] = ["LEFT", "`categories` AS `category`", "`category`.`id` = `company`.`category_id`"];

        $select["where"]["param_`company`.`company_uuid`"] = $token->company_uuid;
        if (isset($args["company_uuid"])) $select["where"]["param_`company`.`uuid`"] = $args["company_uuid"];


        $select = (object) $db->select($select, true);
        // $return["select"] = $select;


        // $return["companies"] = $companies;
        $return["success"] = true;

        return $response->withJson($return, 200);
    });
});
