<?php

use EDGVI10\DBWalker;
use Linkinfo\Functions;
use Slim\Http\Request;
use Slim\Http\Response;

$slim->group("/orders", function ($slim) {
    $slim->post("", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $return["headers"] = $headers;

        return $response->withJson($return, 200);
    });

    $slim->get("[/{order_uuid}]", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $token = Functions::token(trim(str_replace("Bearer ", "", $headers->HTTP_AUTHORIZATION[0])));

        $params = (object) $_GET;
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $select_orders["table"] = "`orders` AS `order`";

        $select_orders["columns"] = [
            "`order`.`uuid`",
            "`order`.`order`",
            "`order`.``",
            "`order`.`name`",
            "`order`.`description`",
            "`order`.`thumbnail`",
            "`order`.`banner`",
            "`order`.`icon`",
            "`order`.`active`",
            "`order`.`created_at`",
            "`order`.`updated_at`",
            "`order`.`deleted_at`",
        ];

        $select_orders["where"]["param_`order`.`company_uuid`"] = $token->company_uuid;
        if (isset($args["order_uuid"])) $select_orders["where"]["param_`order`.`uuid`"] = $args["order_uuid"];

        $select_orders = (object) $db->select($select_orders, true);
        // $return["select_orders"] = $select_orders;

        $orders = [];
        foreach ($select_orders->data as $order) :

            $orders[] = $order;
        endforeach;

        $return["orders"] = $orders;
        $return["success"] = true;

        return $response->withJson($return, 200);
    });
});
