<?php

use EDGVI10\DBWalker;
use Linkinfo\Functions;
use Slim\Http\Request;
use Slim\Http\Response;

$slim->group("/payments", function ($slim) {
    $slim->post("", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $return["headers"] = $headers;

        return $response->withJson($return, 200);
    });

    $slim->get("[/{payment_id}]", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $token = Functions::token(trim(str_replace("Bearer ", "", $headers->HTTP_AUTHORIZATION[0])));

        $params = (object) $_GET;
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $select_payments["table"] = "`opt_payment` AS `payment`";

        $select_payments["columns"] = [
            "`payment`.*",
        ];

        // $select_payments["where"]["param_`payment`.`payment_id`"] = $token->company_uuid;
        if (isset($args["payment_id"])) $select_payments["where"]["param_`payment`.`uuid`"] = $args["payment_id"];

        $select_payments = (object) $db->select($select_payments, true);

        $payments = [];
        foreach ($select_payments->data as $row) :
            $group = $row->group;
            unset($row->group);
            $payment = $row;

            $payments[$payment->group][] = $payment;
        endforeach;

        $return["payments"] = $payments;
        $return["success"] = true;

        return $response->withJson($return, 200);
    });
});
