<?php

use EDGVI10\DBWalker;
use EDGVI10\Helpers;
use Linkinfo\Functions;
use Slim\Http\Request;
use Slim\Http\Response;

$slim->group("/products", function ($slim) {
    $slim->post("", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $token = Functions::token($headers->HTTP_AUTHORIZATION[0]);

        $headers = (object) $request->getHeaders();

        $params = (object) $_GET;
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $category = (object) [];

        $category->local_id = $data->category_id;

        $category->uuid = $db->UUID();
        $category->company_uuid = $token->company_uuid;
        $category->slug = Helpers::slugfy($data->category_name);
        $category->name = $data->category_name;

        $select_categories = (object) $db->select([
            "table" => "categories",
            "where" => [
                "param_`company_uuid`" => $token->company_uuid,
                "param_`local_id`" => $category->local_id
            ]
        ]);

        if (count($select_categories->data) > 0) :
            $category = $select_categories->data[0];
        else :
            $insert_category = [];
            $insert_category["table"] = "categories";
            $insert_category["data"] = (array) $category;

            $insert_category = (object) $db->insert($insert_category);

            $category->id = $insert_category->insert_id;
            $return["log"][] = "Categoria \"{$category->name}\" cadastrada";
        endif;

        $product = (object) [];

        $product->uuid = $db->UUID();
        $product->company_uuid = $token->company_uuid;

        $product->ref = $data->ref;
        $product->code = $data->code;

        $product->name = $data->name;
        $product->description = $data->description;

        $product->thumbnail = $data->thumbnail;
        $product->banner = $data->banner;

        $product->category_id = (int) $category->id;

        $product->unit_price = (float) $data->unit_price;
        $product->unit_count = strtoupper($data->unit_count);
        $product->unit_count_type = (int) $data->unit_count_type;

        $select_products = (object) $db->select(["table" => "`products`", "where" => ["param_`company_uuid`" => $product->company_uuid, "param_`code`" => $product->code]]);

        if (count($select_products->data) > 0) :
            $return["message"] = "Produto já cadastrado";
        else :
            $insert_product = (object) $db->insert(["table" => "`products`", "data" => (array) $product], true);

            if (!$insert_product->success) :
                $return["message"] = "Falha ao cadastrar produto";
                $return["debug"] = $insert_product;
            else :
                $product->id = $insert_product->insert_id;
                $return["log"][] = "Produto \"{$product->name}\" cadastrado";

                $options = [];
                if (count($data->options) > 0) :
                    foreach ($data->options as $option) :
                        $option = (object) $option;
                        $option->uuid = $db->UUID();
                        $option->product_uuid = $product->uuid;
                        $option->checked = (int) $product->checked;

                        $insert_option = [];
                        $insert_option["table"] = "`products_options`";
                        $insert_option["data"] = (array) $option;

                        $insert_option = (object) $db->insert($insert_option, true);
                        if ($insert_option->success) :
                            $option->id = $insert_option->insert_id;
                            $options[] = $option;
                            $return["log"][] = "Opção \"{$option->label}\" cadastrada";
                        else :
                            $return["log"][] = "Falha ao cadastrar opção \"{$option->label}\"";
                            $return["options_debug"][] = $insert_option;
                        endif;
                    endforeach;
                endif;

                $product->options = $options;

                $return["success"] = $insert_product->success;
                $return["products"] = $product;
            endif;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->get("[/{product_uuid}]", function (Request $request, Response $response, $args) {
        global $pkg;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = (object) $request->getHeaders();
        $token = Functions::token($headers->HTTP_AUTHORIZATION[0]);

        $params = (object) $_GET;
        $data = (object) $request->getParsedBody();

        $return = [];
        $return["success"] = false;

        $select_products["table"] = "`products` AS `product`";

        $select_products["columns"] = [
            "`product`.`id`",
            "`product`.`uuid`",
            "`product`.`ref`",
            "`product`.`code`",
            "`product`.`name`",
            "`product`.`description`",

            "`product`.`thumbnail`",
            "`product`.`banner`",

            "`product`.`unit_price`",
            "`product`.`unit_count`",
            "`product`.`unit_count_type`",

            "`category`.`uuid` AS `category_uuid`",
            "`category`.`name` AS `category_name`",

            "'' AS `options`",

            "`product`.`active`",
            "`product`.`created_at`",
            "`product`.`updated_at`",
            "`product`.`deleted_at`",
        ];

        $select_products["joins"][] = ["LEFT", "`categories` AS `category`", "`category`.`id` = `product`.`category_id`"];

        $select_products["where"]["param_`product`.`company_uuid`"] = $token->company_uuid;
        if (isset($args["product_uuid"])) $select_products["where"]["param_`product`.`uuid`"] = $args["product_uuid"];


        $select_products = (object) $db->select($select_products, true);
        // $return["select_products"] = $select_products;

        $products = [];
        foreach ($select_products->data as $product) :
            $select_option = [];
            $select_option["table"] = "`products_options` AS `option`";
            $select_option["columns"] = [
                "`option`.`uuid`",
                "`option`.`group`",
                "`option`.`label`",
                "`option`.`description`",
                "`option`.`adicional_price`",
                "`option`.`checked`",

                "`option`.`active`",
                "`option`.`created_at`",
                "`option`.`updated_at`",
                "`option`.`deleted_at`",
            ];
            $select_option["where"]["param_`option`.`product_uuid`"] = $product->uuid;
            $select_option["order_by"] = ["`group` ASC, `checked` DESC, `adicional_price` ASC"];
            $select_option = (object) $db->select($select_option);

            $product->unit_price = (float) $product->unit_price;

            unset($product->id);
            $options = [];
            foreach ($select_option->data as $option) :
                $group = $option->group;
                $option->checked = (bool) $option->checked;
                $option->adicional_price = (float) $option->adicional_price;
                unset($option->group);
                $options[$group][] = $option;
            endforeach;

            $product->options = $options;

            $products[] = $product;
        endforeach;

        $return["products"] = $products;
        $return["success"] = true;

        return $response->withJson($return, 200);
    });
});
