<?php

use Slim\Http\Request;
use Slim\Http\Response;

use EDGVI10\DBWalker;
use EDGVI10\Helpers;

function CustomerRegister($data)
{
}

$slim->group("/customers", function ($slim) {
    $slim->post("/{company_slug}", function (Request $request, Response $response, $args) {
        $return = [];
        $return["success"] = false;

        global $env;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $data = (object) $request->getParsedBody();

        $select_company = [];
        $select_company["table"] = "`companies` AS `company`";
        $select_company["where"]["param_`company`.`slug`"] = $args["company_slug"];
        $select_company["where"]["param_`company`.`active`"] = true;

        $select_company = (object) $db->select($select_company);
        $company = $select_company->data[0];

        $customer = [];

        $customer["uuid"] = $db->UUID();
        $customer["company_uuid"] = $company->uuid;
        $customer["name"] = $data->name;
        $customer["document"] = $data->document;
        $customer["email"] = $data->email;
        $customer["phone"] = $data->phone;
        $customer["password"] = md5($data->password);

        $insert_customer = [];
        $insert_customer["table"] = "customers";
        $insert_customer["data"] = $customer;

        $insert_customer = (object) $db->insert($insert_customer, true);

        if (!$insert_customer->success) :
            $return["message"][] = "Falha ao cadastrar cliente";
            $return["debug"]["insert_customer"] = $insert_customer;
        else :
            // $return["customer_create"] = $insert_customer;

            $customer = (object) $customer;

            $customer_asaas = [];
            $customer_asaas["name"] = $customer->name;
            $customer_asaas["cpfCnpj"] = $customer->document;
            $customer_asaas["cpfCnpj"] = $customer->document;
            $customer_asaas["email"] = $customer->email;
            $customer_asaas["mobilePhone"] = $customer->phone;

            $call_options = [];
            $call_options["method"] = "POST";
            $call_options["endpoint"] = "{$env->asaas_url}/customers";
            $call_options["data"] = $customer_asaas;

            $call_options["headers"][] = "access_token: {$env->asaas_token}";

            $create_asaas_customer = (object) Helpers::call($call_options);

            // $return["create_asaas_customer"] = $create_asaas_customer->response;
            $asaas_customer = (object) $create_asaas_customer->response;

            $insert_asaas_relation = [];
            $insert_asaas_relation["table"] = "`asaas_relation`";
            $insert_asaas_relation["data"] = [
                "customer_uuid" => $customer->uuid,
                "asaas_id" => $asaas_customer->id,
            ];
            $insert_asaas_relation = $db->insert($insert_asaas_relation);

            $customer->asaas_id = $asaas_customer->id;
            $return["customer"] = $customer;

            $return["success"] = true;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->get("[/{company_slug}[/{customer_uuid}]]", function (Request $request, Response $response, $args) {
        $return = [];
        $return["success"] = false;

        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $company_slug = $args["company_slug"];

        $select_customers = [];
        $select_customers["table"] = "`customers` AS `customer`";
        $select_customers["columns"] = [
            "customer.uuid",
            "company.uuid AS company_uuid",
            "company.name AS company_name",
            "company.fancyname AS company_fancyname",
            "customer.name",
            "customer.document",
            "customer.email",
            "customer.phone",
            "customer.obs",
            "asaas.asaas_id",
            "customer.active",
            "customer.created_at",
            "customer.updated_at",
            "customer.deleted_at",
        ];
        $select_customers["joins"][] = ["RIGHT", "`companies` AS `company`", "`company`.`uuid` = `customer`.`company_uuid`"];
        $select_customers["joins"][] = ["LEFT", "`asaas_relation` AS `asaas`", "`asaas`.`customer_uuid` = `customer`.`uuid`"];
        // $select_customers["where"]["param_`customer`.`company_uuid`"] = $company_slug;

        $select_customers = (object) $db->select($select_customers, true);

        // $return["debug"]["select_customers"] = $select_customers;

        $remove = ["password"];

        $customers = [];
        foreach ($select_customers->data as $customer) :

            $customers[] = $customer;
        endforeach;

        $return["success"] = $select_customers->success;
        $return["customers"] = $customers;

        return $response->withJson($return, 200);
    });
});
