<?php

use Slim\Http\Request;
use Slim\Http\Response;

use EDGVI10\DBWalker;
use EDGVI10\Helpers;

function ProductRegister($data)
{
}

$slim->group("/products", function ($slim) {
    $slim->post("/", function (Request $request, Response $response, $args) {
        $return = [];
        $return["success"] = false;

        global $env;
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $data = (object) $request->getParsedBody();

        $product = [];

        $product["name"] = $data->name;
        $product["ref"] = $data->ref;
        $product["code"] = $data->code;

        $product["store_uuid"] = $data->store_uuid;
        $product["category_id"] = $data->category_id;

        $select_company = [];
        $select_company["table"] = "`companies` AS `company`";
        $select_company["where"]["param_`company`.`slug`"] = $args["company_slug"];
        $select_company["where"]["param_`company`.`active`"] = true;

        $select_company = (object) $db->select($select_company);
        $company = $select_company->data[0];

        if (!isset($company->uuid)) :
            $products = [];

            $products["uuid"] = $db->UUID();
            $products["company_uuid"] = $company->uuid;
            $products["name"] = $data->name;

            $insert_products = [];
            $insert_products["table"] = "products";
            $insert_products["data"] = $products;

            $insert_products = (object) $db->insert($insert_products, true);

            if (!$insert_products->success) :
                $return["message"][] = "Falha ao cadastrar produto";
                $return["debug"]["insert_products"] = $insert_products;
            else :
                // $return["products_create"] = $insert_products;

                $products = (object) $products;
                $return["products"] = $products;

                $return["success"] = true;
            endif;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->get("[/{company_slug}[/{products_uuid}]]", function (Request $request, Response $response, $args) {
        $return = [];
        $return["success"] = false;

        global $mysql_access;

        $db = new DBWalker($mysql_access);

        // $company_slug = $args["company_slug"];

        $select_products = [];
        $select_products["table"] = "`products` AS `product`";
        // $select_products["columns"] = [
        //     "products.uuid",
        //     "company.uuid AS company_uuid",
        //     "company.name AS company_name",
        //     "company.fancyname AS company_fancyname",
        //     "products.name",
        //     "products.document",
        //     "products.email",
        //     "products.phone",
        //     "products.obs",
        //     "asaas.asaas_id",
        //     "products.active",
        //     "products.created_at",
        //     "products.updated_at",
        //     "products.deleted_at",
        // ];
        $select_products["joins"][] = ["RIGHT", "`companies` AS `company`", "`company`.`uuid` = `product`.`store_uuid`"];
        // $select_products["where"]["param_`company`.`uuid`"] = $company_slug;

        $select_products = (object) $db->select($select_products, true);

        $return["debug"]["select_products"] = $select_products;

        // $remove = ["password"];

        $products = [];
        foreach ($select_products->data as $product) :

            $products[] = $product;
        endforeach;

        $return["success"] = $select_products->success;
        $return["products"] = $products;

        return $response->withJson($return, 200);
    });
});
