<?php

use Slim\Http\Request;
use Slim\Http\Response;

use EDGVI10\DBWalker;
use EDGVI10\Helpers;

$slim->group("/companies/{company_slug}/stores", function ($slim) {
    $slim->post("", function (Request $request, Response $response, array $args) {
        $return = [];
        $return["success"] = false;

        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = $request->getHeaders();
        $data = (object) $request->getParsedBody();

        $required = ["name", "fancyname", "cnpj"];

        $required = Helpers::requiredTest($required, (array) $data);

        if ($required !== true) :
            $return["required"] = $required;
        else :

        endif;

        return $response->withJson($return, 200);
    });

    $slim->get("[/{store_uuid}]", function (Request $request, Response $response, array $args) {
        $return = [];
        $return["success"] = false;

        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $headers = $request->getHeaders();

        $options = (object) [];

        $select_stores = [];
        $select_stores["table"] = "`stores` AS `store`";

        $select_stores["columns"] = [
            "`store`.`uuid`",
            "`store`.`name`",
            "`store`.`fancyname`",

            "`store`.`address`",
            "`store`.`address_neighborhood`",
            "`store`.`address_city`",
            "`store`.`address_state`",
            "`store`.`address_country`",
            "`store`.`address_latlng`",
        ];
        $select_stores["joins"][] = ["RIGHT", "`companies` AS `company`", "`company`.`uuid` = `store`.`company_uuid`"];

        $select_stores["where"]["param_`store`.`active`"] = true;
        $select_stores["where"]["param_`company`.`slug`"] = $args["company_slug"];

        if (isset($args["store_uuid"])) $select_stores["where"]["param_`store`.`uuid`"] = $args["store_uuid"];

        $select_stores["order_by"] = ["asc_fancyname"];

        $select_stores = (object) $db->select($select_stores);

        // $return["select_stores"] = $select_stores;

        $stores = [];

        $location = $_GET["location"];

        foreach ($select_stores->data as $row) :
            $store = (object) $row;

            // $user_coords = explode(",", $location);
            // $distance = Helpers::distance($user_coords);

            $stores[] = $store;
        endforeach;

        $return["success"] = $select_stores->success;
        $return["stores"] = $stores;

        return $response->withJson($return, 200);
    });
});
