<?php

use EDGVI10\Helpers;
use Linkinfo\Companies;
use Linkinfo\Functions;
use Linkinfo\Products;
use Slim\Http\Request;
use Slim\Http\Response;

$slim->group("/companies", function ($slim) {
    $slim->get("", function (Request $request, Response $response, array $args) {
        $return = [];
        $return["success"] = false;

        $headers = $request->getHeaders();

        $options = (object) [];
        // $options->company_slug = $args["company_slug"];

        $companies = (object) Functions::getCompanies($options);
        if (!$companies->success) :
            $return = $companies;
        else :

            if (count($companies->data) === 0) :
                $return["message"] = "Nenhuma empresa encontrada";
            else :
                $company = $companies->data[0];
                if (!$company->active) :
                    $return["message"] = "Empresa bloqueada";
                else :
                    $categories_options = (object) [];
                    $categories_options->company_uuid = $company->uuid;

                    $categories = (object) Functions::getCategories($categories_options);

                    $products_options = [];
                    $products_options["company_uuid"] = $company->uuid;
                    $products = (object) Products::list($products_options);

                    $company->categories = $categories->data;
                    $company->products = $products->data;

                    $return["company"] = $company;
                    $return["success"] = true;
                endif;
            endif;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->get("/download", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        // $access_token = $args["access_token"];
        // $options["user_uuid"] = Functions::getUserCode($access_token);

        $return = (array) Companies::list();

        return $response->withJson($return, 200);
    });
});
